import * as React from 'react';

import Checkbox from '../../../../ui/Checkbox';
import { IPlaneTreeItem } from '../../../../ui/VirtualTreeList';
import ActionTreeListItem from '../../Actions/ActionTreeListItem/component';
import { IAction, IRolesInfo } from '../../Actions/types';

interface ITreeListItemProps {
    item: IPlaneTreeItem<IAction>;
    actionsTypesWithCount: Record<string, number>;
    rolesInfo: IRolesInfo;
    getRoles: () => void;
    className: string;
    onChange: (value) => void;
    selectedActions: Record<string, boolean>;
}

export default class ActionsUpdateListItem extends React.Component<ITreeListItemProps> {
    onCheckboxChange(item, value, checked = {}) {
        const { onChange } = this.props;
        const { meta, data } = item;
        checked[data.action_id] = value ;

        if (meta.children) {
            meta.children.map((el) => {
                this.onCheckboxChange(el, value, checked);
            });
        } else {
            onChange(checked);
        }
    }

    render() {
        const { actionsTypesWithCount, rolesInfo, getRoles, item, className, selectedActions } = this.props;
        const { data } = item;

        return <div className={className}>
            <Checkbox checked={selectedActions[data.action_id]}
                      plain
                      onChange={(e) => {
                          this.onCheckboxChange.call(this, item, e);
                      }}/>
            <ActionTreeListItem actionsTypesWithCount={actionsTypesWithCount}
                                item={item}
                                rolesInfo={rolesInfo}
                                getRoles={getRoles.bind(this)}
                                isForUpdate={true}/>
        </div>;
    }
}
