import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS: { [key: string]: string } = {
    GET_ACTIONS: 'GET_ACTIONS',
    GET_ROLES: 'GET_ROLES',
    ADD_ACTION_PROPOSE: 'ADD_ACTION_PROPOSE',
};

export const SETTINGS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_ACTIONS]: {
        api: 'actions/list',
        cgiObj: {
            action_id: null,
            report: null, //compact
        },
    },
    [REQUESTS.GET_ROLES]: {
        api: 'roles/list',
        cgiObj: {
            action_id: null,
        },
    },
    [REQUESTS.ADD_ACTION_PROPOSE]: {
        method: REQUEST_METHOD.POST,
        api: `actions/propose`,
        cgiObj: {
            comment: null,
        },
    },
};
