import * as React from 'react';
import XLSX from 'xlsx';

import { Dict } from '../../../../../types';
import { Button, ButtonTypes } from '../../../../ui/Button';
import Checkbox from '../../../../ui/Checkbox';
import { Window } from '../../../../ui/FullModal';
import * as coreStyle from '../../../../ui/index.css';
import { Link } from '../../../../ui/Link';
import { Request2 } from '../../../../utils/request';
import { ProgressBar } from '../../../ProgressBar';
import QueryScheduler, { COUNT_FIRST, IProgressData } from '../../../QueryScheduler/QueryScheduler';
import { REQUESTS, SETTINGS_REQUESTS } from '../../request';
import * as style from './index.css';

enum FIELDS {
    TAG = 'tag',
    NEW_GROUP = 'group'
}

const SHEET_NAME = 'All Tags';

export class TagAttrModal extends React.Component<any> {
    request = new Request2({ requestConfigs: SETTINGS_REQUESTS });
    state = {
        error: null,
        addAction: true,
        arr: [],

        uploadingProgress: {
            queue: [],
            success: [],
            errors: [],
        },
    };

    changeTypeAction() {
        this.setState({
            addAction: !this.state.addAction,
        });
    }

    readFile() {
        const file: HTMLInputElement = document.createElement('input');
        file.type = 'file';
        file.multiple = true;
        file.style.display = 'none';
        document.body.appendChild(file);
        file.click();
        file.onchange = (e: any) => {
            e.stopPropagation();
            e.preventDefault();
            const files = e.target.files;
            const reader = new FileReader();
            reader.onload = (e: any) => {
                const data = e.target.result;

                const workbook = XLSX.read(data, { type: 'array' });

                const sheet = workbook.Sheets[SHEET_NAME] || workbook.Sheets[workbook.SheetNames[0]];
                const arr = XLSX.utils.sheet_to_json(sheet);

                this.setState({
                    arr: arr.filter((i: Dict<any>) => i[FIELDS.TAG] && i[FIELDS.NEW_GROUP]),
                });
            };

            reader.readAsArrayBuffer(files[0]);
        };
    }

    updateTags() {
        const tagsObj = JSON.parse(JSON.stringify(this.props.tags)).reduce((_p, _c) => {
            delete _c['description_index'];

            return { ..._p, ...{ [_c.name]: _c } };
        }, {});

        const arr = this.state.arr.map((item: any) => {
            const tag = tagsObj && item[FIELDS.TAG] && tagsObj[item[FIELDS.TAG]] || {};
            if (tag.meta && tag.meta.groupping_attributes && tag.meta.groupping_attributes) {
                const newAttrs = item[FIELDS.NEW_GROUP]
                    && item[FIELDS.NEW_GROUP]
                        .split(',')
                        .map(tag => tag.trim()) || [];

                if (this.state.addAction) {
                    tag.meta.groupping_attributes = [
                        ...tag.meta.groupping_attributes,
                        ...newAttrs];
                } else {
                    tag.meta.groupping_attributes = newAttrs;
                }
            }

            return tagsObj[item[FIELDS.TAG]];
        });
        const uploadingProgress: any = this.state.uploadingProgress;
        uploadingProgress.queue = arr.filter(i => i);
        this.setState((state) => ({
            ...state,
            uploadingProgress,
        }), () => {

            const queue = this.state.uploadingProgress.queue
                .map((body) => this.request.exec.bind(this.request, REQUESTS.ADD_TAG,
                    {
                        body,
                    }));

            const qs = new QueryScheduler({
                queue,
                limit: COUNT_FIRST,
                onProgress: this.onProgress.bind(this),
                onSuccess: this.onSuccess.bind(this),
            });

            qs.run();
        });
    }

    onProgress(data: IProgressData) {
        const { failed, queue, success } = data;

        const uploadingProgress = {
            queue,
            success,
            errors: failed,
        };

        this.setState({ uploadingProgress });
    }

    onSuccess(data: IProgressData) {
        const { failed, queue, success } = data;

        const uploadingProgress = {
            queue,
            success,
            errors: failed,
        };

        this.setState({ uploadingProgress }, () => {
            if (!failed.length) {
                this.props.onClose();
                this.props.update();
            }
        });
    }

    render() {
        const errorLength = this.state.uploadingProgress.errors.length;

        return <Window className={style.component}
                       onClose={this.props.onClose.bind(this)}
                       error={this.state.error}
                       title={'Атрибуты для тегов из Excel'}>
            <Button onClick={this.readFile.bind(this)}>Excel</Button>
            <fieldset>
                <legend>Стат</legend>
                <div>Тегов: <strong>{this.state.arr.length}</strong></div>
            </fieldset>

            <Checkbox checked={this.state.addAction} onChange={this.changeTypeAction.bind(this)}/>
            <span className={style.action}>{this.state.addAction ? 'Добавить' : 'Заменить'}</span>
            <div>
                <ProgressBar allLength={this.state.uploadingProgress.queue.length}
                             successLength={this.state.uploadingProgress.success.length}
                             errors={this.state.uploadingProgress.errors}/>
                {
                    errorLength && <Link href={`${location.origin}${location.pathname}#/settings/error-log`}
                                         target={'_blank'}>Ошибки: {errorLength}</Link>
                    || null
                }
            </div>
            <div className={`${coreStyle.full_width} ${coreStyle.button_container}`}>
                <Button onClick={this.props.onClose.bind(this)} colorType={ButtonTypes.negative}>Закрыть</Button>
                <Button colorType={ButtonTypes.positive}
                        onClick={this.updateTags.bind(this)}
                        disabled={!this.state.arr.length || !this.props.tags.length}>Обработать</Button>
            </div>
        </Window>;
    }
}
