import * as React from 'react';
import XLSX from 'xlsx';

import { Button, ButtonTypes } from '../../../ui/Button';
import { ComingSoon } from '../../../utils/navigation';
import { Request2 } from '../../../utils/request';
import { GVARS_INTERFACE_ATTRIBUTES_PREFIX, REQUESTS, SETTINGS_REQUESTS } from '../request';
import { IAttributesStateToProps } from './index';
import * as style from './index.css';
import TagAttrModal from './TagAttrModal';

type IAttributesProps = IAttributesStateToProps

const TAGS_DESCRIPTION = 'tags_description';

export class Attributes extends React.Component<IAttributesProps> {
    request = new Request2({ requestConfigs: SETTINGS_REQUESTS });
    state = {
        tagAttrModalIsOpen: false,
        tagsIsLoading: true,
        tagError: null,
        tags: [],
        tagAttributes: [],
    };

    componentDidMount(): void {
        this.getTags();
    }

    getTagAttr() {
        this.request.exec(REQUESTS.GET_ATTRIBUTES)
            .then(response => {
                const _tag_attributes = response?.settings
                    ?.filter(i => i.setting_key = `${GVARS_INTERFACE_ATTRIBUTES_PREFIX}.${TAGS_DESCRIPTION}`)[0];
                const tagAttributes = _tag_attributes && _tag_attributes.setting_value
                    && _tag_attributes.setting_value.split(',') || [];
                this.setState({
                    tagAttributes,
                });
            });
    }

    getTags() {
        this.request.exec(REQUESTS.GET_TAGS)
            .then(response => {
                this.setState({
                    tagsIsLoading: false,
                    tags: response.records && response.records.map(tag => {
                        let meta = {};
                        try {
                            meta = JSON.parse(tag.meta);
                        } catch (e) {
                            meta = tag.meta;
                        }

                        return Object.assign({}, tag, { meta });
                    }) || [],
                }, () => {
                    this.getTagAttr();
                });
            })
            .catch(tagError => {
                this.setState({
                    tagsIsLoading: false,
                    tagError,
                });
            });
    }

    modalHandler(type: string, state: boolean) {
        this.setState({
            [type]: state,
        });
    }

    downloadTags() {
        const workbook = XLSX.utils.book_new();
        const data = XLSX.utils.json_to_sheet(this.state.tags.map((tag: any) => ({
            tag: tag.name,
            group: tag.meta && tag.meta.groupping_attributes && tag.meta.groupping_attributes.join(','),
        })));

        const attr = XLSX.utils.json_to_sheet(this.state.tagAttributes.map(i => ({ group: i })));
        XLSX.utils.book_append_sheet(workbook, data, `tags`);
        XLSX.utils.book_append_sheet(workbook, attr, `groups`);
        XLSX.writeFile(workbook, `tags.xlsx`);
    }

    render() {
        return <div className={style.component}>
            {
                this.state.tagAttrModalIsOpen &&
                <TagAttrModal update={this.getTags.bind(this)}
                              onClose={this.modalHandler.bind(this, 'tagAttrModalIsOpen', false)}
                              tags={this.state.tags}/>
            }
            <h2>Атрибуты для тегов</h2>
            <div className={style.tag_attributes}>
                {this.state.tagAttributes?.join(', ')}
            </div>
            <div className={`${style.tag_controls}`}>
                <Button colorType={ButtonTypes.positive}
                        onClick={this.modalHandler.bind(this, 'tagAttrModalIsOpen', true)}>Обновить из excel</Button>

                <Button disabled={!this.state.tags.length || !this.state.tagAttributes.length}
                        isLoading={this.state.tagsIsLoading}
                        onClick={this.downloadTags.bind(this)}>Скачать теги+атрибуты</Button>
            </div>
            <h2>Атрибуты для ролей</h2>
            <ComingSoon/>
            <h2>Атрибуты для экшенов</h2>
            <ComingSoon/>
            <h2>Атрибуты для чего там ещё</h2>
            <ComingSoon/>
        </div>;
    }
}
