import { connect } from 'react-redux';

import { IStore } from '../../App/store';
import { Attributes } from './component';

export interface IAttributesStateToProps {
    rawSettings: { setting_key: string; setting_value: string }[];
}

export const mapStateToProps = (store: IStore): IAttributesStateToProps => {
    return {
        rawSettings: store.AdminUser && store.AdminUser.rawSettings || [],
    };
};

export function mapDispatchToProps(dispatch: any) {
    return {};
}

export default connect<IAttributesStateToProps, {}, {}>(mapStateToProps, mapDispatchToProps)(Attributes);
