import React from 'react';
import { useParams } from 'react-router-dom';

import { ONE_SECOND } from '../../../../constants';
import { useRequestHandler } from '../../../../hooks/useRequestHandler';
import FormatDate from '../../../../ui/FormatDate';
import { Window } from '../../../../ui/FullModal';
import { Request2 } from '../../../../utils/request';
import Spin from '../../../Spin';
import { IBot, IBP_STATE } from '../component';
import { BOTS_REQUESTS, REQUESTS } from '../request';

const BotModalStat = (props: any) => {
    const { bot_name } = useParams();
    const request = new Request2({ requestConfigs: BOTS_REQUESTS });
    const [bot, setState] = React.useState<IBot>({} as IBot);
    const requestOptions = React.useMemo(() => {
        return {
            requestName: REQUESTS.GET_BOTS,
            requestOptions: {
                queryParams: {
                    ids: bot_name,
                },
            },
        };
    }, [bot_name]);
    const handler = (response) => {
        setState(response?.rt_backgrounds?.[0]);
    };

    const [isLoading, , error, makeResponse] = useRequestHandler(request, requestOptions, handler);

    React.useEffect(() => {
        makeResponse();
    }, []);

    const { background_process_state = {} as IBP_STATE } = bot;

    return <Window title={`Статус бота ${bot_name}`} onClose={props.onClose} error={error}>
        {
            isLoading ? <Spin/> : <>
                <div>Бот: <strong>{bot_name}</strong></div>
                <div>Статус: <strong>{background_process_state.status}</strong></div>
                <div>Тип: <strong>{background_process_state.type}</strong></div>
                <div>Хост: <strong>{background_process_state.host}</strong></div>
                <div>Последний запуск: <strong><FormatDate value={background_process_state.last_execution * ONE_SECOND}
                                                           withSecond/></strong></div>
                <div>Частота: <strong>{bot?.bp_settings?.period}</strong></div>
            </>
        }
    </Window>;
};

export { BotModalStat };
