import React from 'react';

import { UserInfoHandler } from '../../../../models/user';
import { Link } from '../../../../ui/Link';
import { Request2 } from '../../../../utils/request';
import { Copy } from '../../../Copy';
import { IBotProposition } from '../component';
import style from '../index.css';
import { BOTS_REQUESTS } from '../request';

interface IBotPropositionsProps {
    propositions: IBotProposition[];
    users: Record<string, any>;
}

interface IBotPropositionsState {}

export class BotPropositions extends React.Component<IBotPropositionsProps, IBotPropositionsState> {
    request = new Request2({ requestConfigs: BOTS_REQUESTS });

    render() {
        const { propositions, users } = this.props;

        return <div>
            {propositions?.length
                ? propositions.map((prop) => {
                    const authorInfo = users[prop.proposition_author];
                    const author = UserInfoHandler.getPrintName.call(authorInfo);
                    const href = `#/settings/bots/proposition/${prop.bp_type}/${prop.bp_name}`;

                    return <div key={prop.proposition_id} className={style.proposition}>
                        <Link href={href}>
                            <div><b>Бот: </b> {prop.bp_name ?? '-'}</div>
                            <div><b>Описание: </b> {prop.proposition_description ?? '-'}</div>
                            <div><b>Автор: </b> {author ?? '-'}</div>
                        </Link>
                        <Copy text={`${location.origin}${location.pathname}${href}`}>
                            Копировать ссылку
                        </Copy>
                    </div>;
                })
                : <h3>Предложений ботов не найдено</h3>
            }
        </div>;
    }
}
