import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS = {
    GET_BOTS: 'GET_BOTS',
    REMOVE_BOTS: 'REMOVE_BOTS',
    UPSERT_BOTS: 'UPSERT_BOTS',
    GET_BOT_CONFIGURATIONS: 'GET_BOT_CONFIGURATIONS',
    GET_BOT_GROUPS: 'GET_BOT_GROUPS',
    PROPOSE_BOT: 'PROPOSE_BOT',
    CONFIRM_BOT: 'CONFIRM_BOT',
    REJECT_BOT: 'REJECT_BOT',
};

export const BOTS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_BOTS]: {
        api: 'bg/info',
        cgiObj: {
            ids: null,
            bp_name: null,
            report: null,
            ctype: null,
            bp_type: null,
        },
    },
    [REQUESTS.REMOVE_BOTS]: {
        api: 'bg/remove',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.UPSERT_BOTS]: {
        api: 'bg/upsert',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.GET_BOT_CONFIGURATIONS]: {
        api: 'alerts/meta',
    },
    [REQUESTS.GET_BOT_GROUPS]: {
        api: 'alerts/info',
    },
    [REQUESTS.PROPOSE_BOT]: {
        api: 'bg/propose',
        method: REQUEST_METHOD.POST,
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.CONFIRM_BOT]: {
        api: 'bg/confirm',
        method: REQUEST_METHOD.POST,
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.REJECT_BOT]: {
        api: 'bg/reject',
        method: REQUEST_METHOD.POST,
        cgiObj: {
            comment: null,
        },
    },
};
