import { Dict } from '../../../../types';
import { controlType, ISchemaItem, SchemaItemVisual } from '../../FormConstructor/types';

export enum PRE_ACTION_MESSAGE_TYPE {
    PLAIN_TEXT = 'plaintext',
    WELCOME_TEXT = 'welcome_text',
    IMAGE = 'image',
    IMAGE_LINK = 'image_link',
    IMAGES_LIST = 'images_list',
    VIDEO = 'video',
}

//Variable SCHEMA, can't use right now because of hard setInitialData logic
export const __OLD_SCHEMA_SCHEMA = {
    type: controlType.structure,
    structure: {
        type: {
            type: controlType.variants,
            variants: ['options', 'message'],
            default: 'options',
            read_only: true,
        },
        options: {
            type: controlType.array_types,
            array_type: {
                option: {
                    type: controlType.variable,
                    control_field: {
                        type: {
                            type: controlType.variants,
                            variants: ['options', 'message'],
                            default: 'message',
                        },
                    },
                    variants_fields: {
                        options: {
                            text: { type: controlType.text },
                            options: { type: controlType.json },
                            show_if: { type: controlType.json },
                        },
                        message: {
                            text: { type: controlType.text },
                            show_if: { type: controlType.json },
                            history_text: { type: controlType.text },
                            message_text: { type: controlType.text },
                            node: { type: controlType.string },
                        },
                    },
                },
            },
        },
    },
    display_name: 'schema',
};

const SCHEMA_SCHEMA = {
    type: controlType.structure,
    structure: {
        type: {
            type: controlType.variants,
            variants: ['options', 'message'],
            display_name: 'Тип элемента схемы',
            default: 'options',
            read_only: true,
        },
        options: {
            display_name: 'Массив опций',
            type: controlType.array_types,
            array_type: {
                type: {
                    type: controlType.variants,
                    variants: ['options', 'message', 'deeplink', 'logout', 'support_center'],
                    display_name: 'Тип элемента схемы',
                    default: 'message',
                    editable: true,
                },
                text: { type: controlType.string, display_name: 'Текст' },
                link: { type: controlType.string, display_name: 'Ссылка', description: 'Только для deeplink' },
                history_text: {
                    type: controlType.string,
                    display_name: 'Текст по нажатию',
                    description: 'Какой текст отправить в чат по нажатию на этот пункт меню',
                },
                node: {
                    type: controlType.string,
                    display_name: 'Вершина для перехода',
                    description: 'В какую вершину переходить по нажатию',
                },
                message_text: { type: controlType.string, display_name: '' },
                show_if: { type: controlType.json, display_name: 'Условие показа' },
                options: { type: controlType.json, display_name: 'Вложенные опции' },
            },
        },
    },
    display_name: 'Схема',
};

export const CHAT_NODE_SCHEMA: Dict<ISchemaItem> = {
    id: { type: controlType.string, display_name: 'id', required: true },
    __introScreenType: {
        type: controlType.variable,
        control_field: {
            action_type: {
                variants:
                    [
                        'button',
                        'license', 'passport',
                        'passport_biographical', 'credit_card', 'user_message',
                        'chat_closed', 'tree',
                        'context_buttons',
                        'feedback_current', 'feedback_past', 'deeplink',
                        'enter_promocode',
                    ],
                type: controlType.variants,
                display_name: 'Тип действия',
                description: 'Тип действия, которое пользователь должен выполнить в этом чате',
                default: 'button',
                editable: true,
            },
        },
        default_fields: {
            action_button_text: {
                type: controlType.string,
                display_name: 'Текст кнопки',
                description: 'Текст, который будет написан на кнопке',
            },
        },
        variants_fields: {
            deeplink: {
                action_button_text: {
                    type: controlType.string,
                    display_name: 'Текст кнопки',
                    description: 'Текст, который будет написан на кнопке',
                },
                link: {
                    type: controlType.string,
                    display_name: 'Ссылка в приложении',
                },
            },
            tree: {
                schema: SCHEMA_SCHEMA,
                fallback_node: {
                    type: controlType.string,
                    display_name: 'Запасная нода',
                    description: 'Если элемент управления - схема, то в какую вершину отправить человека, если его сообщение не подходит ни под один вариант',
                },
            },
            context_buttons: {
                schema: SCHEMA_SCHEMA,
                fallback_node: {
                    type: controlType.string,
                    display_name: 'Запасная нода',
                    description: 'Если элемент управления - схема, то в какую вершину отправить человека, если его сообщение не подходит ни под один вариант',
                },
            },
        },
    },
    pre_action_messages: {
        type: controlType.array_types,
        array_type: {
            type: controlType.variable,
            control_field: {
                type: {
                    variants:
                        [
                            PRE_ACTION_MESSAGE_TYPE.PLAIN_TEXT,
                            PRE_ACTION_MESSAGE_TYPE.IMAGE_LINK,
                            PRE_ACTION_MESSAGE_TYPE.IMAGE,
                            PRE_ACTION_MESSAGE_TYPE.VIDEO,
                            PRE_ACTION_MESSAGE_TYPE.WELCOME_TEXT,
                            'media_resources',
                            'separator',
                            'location',
                            'sticker',
                            'feedback_dialogue',
                        ],
                    type: controlType.variants,
                    multi_select: false,
                    display_name: 'Тип сообщения',
                    default: 'plaintext',
                    editable: true,
                },
            },
            default_fields: {
                text: { type: controlType.text, display_name: 'Текст' },
            },
            variants_fields: {
                image_link: {
                    text: { type: controlType.text, display_name: 'Текст' },
                    link: { type: controlType.string, display_name: 'Ссылка' },
                    icon: {
                        type: controlType.string, display_name: 'Ссылка на икноку',
                        visual: SchemaItemVisual.FILE,
                    },
                },
                video: {
                    text: {
                        type: controlType.string,
                        display_name: 'Ссылка на видео',
                        visual: SchemaItemVisual.FILE,
                    },
                },
                image: {
                    text: {
                        type: controlType.string,
                        display_name: 'Ссылка на изображение',
                        visual: SchemaItemVisual.FILE,
                    },
                },
                media_resources: {
                    resource_content_type: {
                        type: controlType.string,
                        display_name: 'Content type',
                        default: 'video/mp4',
                    },
                    resource_link: {
                        type: controlType.string,
                        display_name: 'Ссылка',
                        visual: SchemaItemVisual.FILE,
                    },
                    text: {
                        type: controlType.string,
                        display_name: 'Медиаресурс ID',
                    },
                },
            },
        },
        display_name: 'Сообщения',
        description: 'Сообщения, которые надо отправить в чат от имени робота по заходу в эту вершину графа',
    },
    allowed_message_types: {
        variants:
            [
                'plaintext',
                'CreditCardBinding',
                'media_resources',
                'order',
                'location',
                'sticker',
            ],
        type: controlType.variants,
        multi_select: true,
        editable: true,
        display_name: 'Разрешенные типы сообщений',
    },
    on_entry_actions: {
        type: controlType.array_types,
        array_type: {
            type: controlType.json,
            display_name: 'Действие',
        },
        display_name: 'Действия на входе',
        description: 'Массив действий, которые надо сделать по входу в эту вершину',
    },
    use_classifier: { type: controlType.bool, display_name: 'use classifier' },
    put_tag_on_entry: { type: controlType.bool, display_name: 'put tag on entry' },
    support_line_tag: { type: controlType.string, display_name: 'support line tag' },
    next_step: { type: controlType.json, display_name: 'next step' },
    __tags: {
        type: controlType.variable,
        control_field: {
            suppress_support_call: {
                type: controlType.bool,
                display_name: 'Запрет на вызов поддержки',
                description: 'Если пользователь в этой вершине отправляет текстовое сообщение, не призывать туда саппорта и не создавать заявку',
            },
        },
        variants_fields: {
            false: {
                support_line_tag: {
                    type: controlType.string,
                    display_name: 'Тег линии',
                    description: 'Какой тег линии вешать на пользователя, если он отправляет текстовое сообщение, находясь в этой вершине',
                },
                put_tag_on_entry: {
                    type: controlType.string,
                    display_name: 'Тег при входе',
                    description: 'Если пользователь оказывается в этой вершине графа, создавать незамедлительно заявку на поддержку и призывать туда оператора.',
                },
            },
        },
    },
};
export const SUPPORT_CHAT = 'support';
