import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS = {
    GET_NOTIFIERS: 'GET_NOTIFIERS',
    GET_LANDINGS: 'GET_LANDINGS',
    UPSERT_NOTIFIERS: 'UPSERT_NOTIFIERS',
};

export const CHATS_EDITOR_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_NOTIFIERS]: {
        api: 'notifiers/info',
        cgiObj: {
            ids: null,
        },
    },
    [REQUESTS.GET_LANDINGS]: {
        api: 'landing/get',
        cgiObj: {
            id: null,
        },
    },
    [REQUESTS.UPSERT_NOTIFIERS]: {
        api: 'notifiers/upsert',
        method: REQUEST_METHOD.POST,
    },
};
