import { Dict } from '../../../../types';

export interface INode {
    action_button_text?: string;
    action_type?: string;
    next_step?: (string & null)[];
    pre_action_messages?: any[];
    id: string;
    support_line_tag?: string;
    allowed_message_types?: any[];
    on_entry_actions?: Dict<any>[];
    style?: any;
    schema?: Dict<any>;
}

export interface IChat {
    name: string;
    notifier_is_active: boolean;
    type: string;
    meta: {
        is_pinned: boolean;
        chat_id: string;
        common_sharding_policy: {
            max_shard: number;
            min_shard: number;
        };
        icon: string;
        title: string;
        use_event_log: boolean;
        theme: {
            bonus_bg: {
                path: string;
                height: number;
                width: number;
            };
            styles: {
                bg_color: string;
                name: string;
                elem_color: string;
                list_item: {
                    unread_indicator_color: string;
                    subtitle_color: string;
                    date_color: string;
                    title_color: string;
                    pinned: boolean;
                    substrate_color?: string;
                };
            };
            color_separator_bg_color: string;
            feedback_bg_color: string;
        };
        is_hidden: boolean;
        is_static: boolean;
        create_on_read: boolean;
        start_from_clean_chat: boolean;
        is_common: boolean;
        bot_class_name: string;
        initial_step_id: string;
        chat_script: {
            items: INode[];
            support_url?: string;
            faq_url?: string;
            missing_nodes_redirect?: string;
        };
        common_instant?: number;
    };
    revision: number;
}
