import React from 'react';

import { CategorizationCategory } from '../../../../models/tag';
import { Link } from '../../../../ui/Link';
import { IPlaneTreeItem } from '../../../../ui/VirtualTreeList';
import { ITreeOption } from '../../../Chats/ClassificationDialog/TreeSuggest';
import * as style from './index.css';

export interface TreePropsClassification {
    showModal: Function;
    showModalRemove: Function;
    readOnly?: boolean;
    onSelect?: (value: ITreeOption) => void;
}

interface IClassificationTreeListItemProps extends TreePropsClassification {
    item: IPlaneTreeItem<CategorizationCategory>;
}

export class ClassificationTreeListItem extends React.Component<IClassificationTreeListItemProps, any> {
    render() {
        const { meta } = this.props?.item?.data;
        const { meta: itemMeta } = this.props?.item;
        const { childrenCount, filteredChildrenCount } = itemMeta;
        const enableItemClick = this.props.readOnly && !childrenCount;
        let onItemClick, onLabelClick = () => {};

        if (enableItemClick) {
            onItemClick = onLabelClick = this.props.onSelect?.bind(this, this.props?.item?.data);
        } else if (!this.props.readOnly) {
            onLabelClick = this.props?.showModal?.bind(this, this.props.item);
        }

        return <div className={`${style.item}`} onClick={onItemClick}>
            <>
                <CallDirection call_direction={meta.call_direction}/>
                <Link className={style.label} onClick={onLabelClick}>
                    {meta.label}
                </Link>
                <strong>
                    {filteredChildrenCount
                        ? filteredChildrenCount || null
                        : childrenCount || null}
                </strong>
                {!this.props.readOnly
                    ? <>
                        <span className={`${style.add_child} ${style.circle}`}
                              onClick={this.props?.showModal?.bind(this, null, this.props?.item?.data?.id)}>
                            +
                        </span>
                        <span className={`${style.remove} ${style.circle}`}
                              onClick={this.props?.showModalRemove?.bind(this, this.props?.item?.data?.id)}>
                            -
                        </span>
                    </>
                    : null
                }
            </>
            <div className={style.keywords}>
                <Origins items={meta.origins || []}/>

                <span className={style.order}>{meta?.order} </span>
                <span>{meta?.keywords?.length && `| keywords: `}
                    <span className={style.keywords_items}>{
                        meta?.keywords?.join(', ')
                    }</span>
                </span>
            </div>
        </div>;
    }
}

const Origins = React.memo((props: { items: string[] }) => {
    return <div className={style.origins}>
        {
            props.items.map(item => {
                return <div className={`${style.origin_item} ${style[item]}`} key={item}>{item}</div>;
            })
        }
    </div>;
});

const CALL_DIRECTION_STRING_LENGTH = 3;

const CallDirection = React.memo((props: { call_direction: string }) => {
    return <div className={`${style.call_direction} ${style[props?.call_direction] || ''}`}>
        {props?.call_direction?.substr(0, CALL_DIRECTION_STRING_LENGTH)}
    </div>;
});
