import React from 'react';

import { CategorizationCategory } from '../../../models/tag';
import { Button, CancelButton } from '../../../ui/Button';
import { Window } from '../../../ui/FullModal';
import * as coreStyle from '../../../ui/index.css';
import { IPlaneTreeItem } from '../../../ui/VirtualTreeList';
import { Copy } from '../../Copy';
import { FormConstructor } from '../../FormConstructor';

interface IEditModalProps {
    onClose: () => void;
    update: () => void;
    schema: any;
    initialData: IPlaneTreeItem<CategorizationCategory> | null;
    error: Error | null;
    isWorking: boolean;
}

export class EditModal extends React.Component<IEditModalProps, any> {
    state = {
        data: {},
    };

    onChange(data) {
        this.setState({
            data,
        });
    }

    render() {
        return <Window onClose={this.props.onClose} title={'Классификация'} error={this.props.error}>
            <div>id: <Copy>{this.props.initialData?.data.id}</Copy></div>
            <FormConstructor schema={this.props.schema || {}}
                             onChange={this.onChange.bind(this)}
                             initialData={this.props.initialData?.data || null}/>
            <div className={coreStyle.button_container}>
                <CancelButton onClick={this.props.onClose}/>
                <Button onClick={this.props.update.bind(this, this.state.data)}
                        isLoading={this.props.isWorking}>Обновить</Button>
            </div>
        </Window>;
    }
}
