import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS = {
    GET_TREE: 'GET_TREE',
    EDIT_TREE: 'EDIT_TREE',
};

export const TREE_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_TREE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'categorization/tree',
    },

    [REQUESTS.EDIT_TREE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'categorization/tree/edit', //add, modify, remove_node
        cgiObj: {
            action: null,
            id: null,
            parent_id: null,
            meta: null,
        },
    },
};
