import React from 'react';

import { BasicUserInfo, UserInfoHandler } from '../../../../models/user';
import { Window } from '../../../../ui/FullModal';
import { IRole } from '../../../Clients/UserRolesView/types';
import { IUserNamesToCopy } from '../TableRoles';
import { AddManageRolesModal } from './AddManageRolesModal';
import style from './index.css';

export interface IAddManageRolesModalProps {
    onClose: () => void;
    selectedUser?: BasicUserInfo;
    selectedRoles: IRole[];
    getUsersData: () => void;
    userNamesToCopy: IUserNamesToCopy[];
}

export const AddManageRolesWindow = (props: IAddManageRolesModalProps) => {
    const { onClose, selectedUser, selectedRoles, getUsersData, userNamesToCopy } = props;
    const selectedUsername = UserInfoHandler.getUsername.call(selectedUser);

    return (
        <Window className={style.addRoleWindow}
                title={`Копирование ролей ${selectedUsername} к ${userNamesToCopy.map(el => el.username).join(', ')}`}
                onClose={onClose}>
            <AddManageRolesModal onClose={onClose}
                                 selectedRoles={selectedRoles}
                                 getUsersData={getUsersData}
                                 userNamesToCopy={userNamesToCopy}/>
        </Window>
    );
};
