import React from 'react';

import { Dict } from '../../../../../types';
import { EMPTY_DATA } from '../../../../constants';
import Checkbox from '../../../../ui/Checkbox';
import style from './index.css';

interface IRoleStatusProps {
    user: { active: boolean};
    printCheckboxes: boolean;
    onChangeCheckbox: (checked: boolean, roleId: string, userId: string) => void;
    roleId: string;
    userId: string;
    selectedUser: Dict<any>;
    checkboxesHash: Dict<any>;
}

export const RoleStatus = (props: IRoleStatusProps) => {
    const { user, printCheckboxes, onChangeCheckbox, roleId, userId, selectedUser, checkboxesHash } = props;
    const checkboxHandler = (checked: boolean) => {
        onChangeCheckbox(checked, roleId, userId);
    };

    return (
        <td className={`${printCheckboxes ? style.roleStatus : ''}`}>
            <div className={style.roleContainer}>
                {
                    printCheckboxes && user?.active
                        ? <Checkbox checked={checkboxesHash[roleId]?.[userId].checked}
                                    onChange={checkboxHandler}
                                    plain
                                    disabled={selectedUser.id !== userId}/>
                        : null
                }
                {user?.active || EMPTY_DATA}
            </div>
        </td>
    );
};
