import React from 'react';

import { BasicUserInfo, UserInfoHandler } from '../../../../../models/user';
import Checkbox from '../../../../../ui/Checkbox';
import { Link } from '../../../../../ui/Link';
import { IRole } from '../../../../Clients/UserRolesView/types';
import style from './index.css';

interface IUserViewProps {
    roles: IRole[];
    user: BasicUserInfo;
    selectedUser: BasicUserInfo;
    setSelectedUser: (BasicUserInfo) => void;
}

export const UserView = (props: IUserViewProps) => {
    const { roles, user, selectedUser, setSelectedUser } = props;
    const onChange = (checked) => {
        if(checked) {
            setSelectedUser(user);
        } else {
            setSelectedUser({});
        }
    };

    const username = UserInfoHandler.getUsername.call(user);
    const userId = UserInfoHandler.getId.call(user);
    const selectedUserId = UserInfoHandler.getId.call(selectedUser);

    return <div className={style.user_view}>
        <div className={style.imgBlock}>
            <img src={`https://center.yandex-team.ru/api/v1/user/${username}/avatar/50.jpg`}/>
            <Checkbox checked={selectedUserId === userId}
                      onChange={onChange}/>
        </div>
        <div>пользователь: {UserInfoHandler.getPrintName.call(user)}</div>
        <div>username: <Link href={`#/clients/${UserInfoHandler.getId.call(user)}/info`}
                             target={'_blank'}>{username}</Link></div>
        <div>email: {UserInfoHandler.getEmail.call(user)}</div>
        <div>roles: {roles?.length}</div>
    </div>;
};
