import React from 'react';

import { BasicUserInfo } from '../../../../models/user';
import { NoInformation } from '../../../../ui/NoInformation';
import { IRole } from '../../../Clients/UserRolesView/types';
import { TableRoles } from '../TableRoles';
import style from './index.css';
import { UserView } from './UserView';

interface IUsersViewProps {
    users: Record<string, BasicUserInfo>;
    roles: Record<string, IRole[]>;
    getUsersData: () => void;
    isLoading: boolean;
}

export const UsersView = (props: IUsersViewProps) => {
    const { roles, users, getUsersData, isLoading } = props;
    const [selectedUser, setSelectedUser] = React.useState<BasicUserInfo>({});

    return <>
        <div className={style.users_view}>
            {
                users &&
                Object.entries(users)?.map(user => {
                    return <UserView user={user[1]}
                                     key={user[0]}
                                     roles={roles?.[user[0]]}
                                     selectedUser={selectedUser}
                                     setSelectedUser={setSelectedUser}/>;
                }) || <NoInformation/>
            }
        </div>
        <TableRoles roles={roles}
                    users={users}
                    selectedUser={selectedUser}
                    getUsersData={getUsersData}
                    isLoading={isLoading}/>
    </>;
};
