import React from 'react';

import { Link } from '../../../../../ui/Link';
import { SimpleError } from '../../../../SimpleError';
import style from './index.css';

interface ICreatingFlagProgressBarProps {
    status: boolean | null;
    error: Error | null;
    attachFlagToSTTicket: () => void;
    ticketKey: string;
}

const AttachingFlagToSTProgressBar = ({
    status,
    error,
    attachFlagToSTTicket,
    ticketKey,
}: ICreatingFlagProgressBarProps) => {

    const barClassName = status === true ? style.success : status === false ? style.error : '';

    return <div className={`${style.progress_bar} ${barClassName}`}>
        <div className={`${style.progress_item} ${barClassName}`}>
            Привязка флага к тикету {ticketKey}
        </div>
        {status === false
            ? <>
                <Link onClick={attachFlagToSTTicket}>Повторить</Link>
                <SimpleError error={error}/>
            </>
            : null}
    </div>;
};

export default AttachingFlagToSTProgressBar;
