import React from 'react';

import { ENVIRONMENT } from '../../../../../../types';
import { Link } from '../../../../../ui/Link';
import { DM_ADMIN_ROLE_ID } from '../../types';
import style from './index.css';

interface IFinalMessageBarProps {
    ticketKey: string;
    attachingToSTTicket: boolean | null;
    creatingPrestableStatus: boolean | null;
    creatingTestingStatus: boolean | null;
    actionName: string;
    onClose: () => {};
}

const FinalMessageBar = ({
    ticketKey,
    attachingToSTTicket,
    creatingPrestableStatus,
    creatingTestingStatus,
    actionName,
    onClose,
}: IFinalMessageBarProps) => {

    return <div className={style.progress_bar}>
        <div className={style.progress_item}>
            {creatingPrestableStatus || creatingTestingStatus
                ? <div>
                    <Link target={'_blank'} href={`#/settings/actions/${actionName}`}>Флаг</Link> создан в окружениях {[
                        ...(creatingPrestableStatus ? [ENVIRONMENT.PRESTABLE] : []),
                        ...(creatingTestingStatus ? [ENVIRONMENT.TESTING] : [])]
                        .join(', ')} и прикреплён к роли <Link target={'_blank'}
                                                               href={`#/settings/roles?role_id=${DM_ADMIN_ROLE_ID}`}>
                        {DM_ADMIN_ROLE_ID}
                    </Link>.
                </div>
                : null}
            {attachingToSTTicket
                ? <div>
                    Флаг прикреплён к тикету <Link target={'_blank'} href={`https://st.yandex-team.ru/${ticketKey}`}>{ticketKey}</Link>
                </div>
                : null}
            <Link onClick={onClose}>Закрыть</Link>
        </div>
    </div>;
};

export default FinalMessageBar;
