import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS = {
    GET_TASKS: 'GET_TASKS',
    EDIT_TASK: 'EDIT_TASK',
    GET_ACTIONS: 'GET_ACTIONS',
    ADD_ACTION: 'ADD_ACTION',
    GET_ROLES: 'GET_ROLES',
    ROLES_UPSERT: 'ROLES_UPSERT',
};
export const KEY_FLAG = '6082d0d63ea0256db1dadf1a--flag';

export const DM: IComponentRequest = {
    [REQUESTS.GET_TASKS]: {
        method: REQUEST_METHOD.GET,
        apiPrefix: API_PREFIXES.ST_API,
        api: 'issues',
        cgiObj: {
            perPage: null,
            query: null,
            fields: `status, ${KEY_FLAG}, versionSingle, key, statusStartTime, summary`,
        },
    },
    [REQUESTS.EDIT_TASK]: {
        method: REQUEST_METHOD.PATCH,
        apiPrefix: API_PREFIXES.ST_API,
        api: 'issues/${id}',
        cgiObj: {
            [KEY_FLAG]: null,
        },
    },
    [REQUESTS.GET_ACTIONS]: {
        method: REQUEST_METHOD.GET,
        api: 'actions/list',
        cgiObj: {
            backend_cluster: null,
        },
    },
    [REQUESTS.GET_ROLES]: {
        method: REQUEST_METHOD.GET,
        api: 'roles/list',
        cgiObj: {
            backend_cluster: null,
        },
    },
    [REQUESTS.ADD_ACTION]: {
        method: REQUEST_METHOD.POST,
        api: 'actions/add',
        cgiObj: {
            backend_cluster: null,
        },
    },
    [REQUESTS.ROLES_UPSERT]: {
        method: REQUEST_METHOD.POST,
        api: 'roles/snapshot/upsert',
        cgiObj: {
            backend_cluster: null,
        },
    },
};
