import produce from 'immer';
import React from 'react';

import { Button, ButtonTypes } from '../../../ui/Button';
import { Window } from '../../../ui/FullModal';
import * as tblStyle from '../../../ui/Table/index.css';
import { Request2 } from '../../../utils/request';
import { SimpleError } from '../../SimpleError';
import Spin from '../../Spin';
import { REQUESTS, SETTINGS_REQUESTS } from '../request';
import * as style from './index.css';

export class ExternalPromo extends React.Component {
    state = {
        isLoading: false,
        error: null,
        data: {} as any,
        chooseFileDialogIsShowing: false,
        isUploading: false,
        errorUpload: null,
    };
    request = new Request2({ requestConfigs: SETTINGS_REQUESTS });

    componentDidMount(): void {
        this.getData();
    }

    getData() {
        this.setState(produce(this.state, draft => {
            draft.error = null;
            draft.isLoading = true;
        }), () => {
            this.request.exec(REQUESTS.GET_EXTERNAL_PROMO)
                .then(response => {
                    this.setState(produce(this.state, draft => {
                        draft.error = null;
                        draft.isLoading = false;
                        draft.data = response;
                    }));
                })
                .catch(error => {
                    this.setState(produce(this.state, draft => {
                        draft.error = error;
                        draft.isLoading = false;
                    }));
                });
        });
    }

    showChooseFileDialog(state) {
        this.setState(produce(this.state, draft => {
            draft.chooseFileDialogIsShowing = state;
        }));
    }

    upload(data) {
        this.setState(produce(this.state, draft => {
            draft.isUploading = true;
        }), () => {
            this.request.exec(REQUESTS.UPLAOD_EXTERNAL_PROMO, {
                body: {
                    codes: data,
                },
            })
                .then(() => {
                    this.setState(produce(this.state, draft => {
                        draft.isUploading = false;
                        draft.error = null;
                        draft.chooseFileDialogIsShowing = false;
                    }), () => {
                        this.getData();
                    });
                })
                .catch(error => {
                    this.setState(produce(this.state, draft => {
                        draft.isUploading = false;
                        draft.errorUpload = error;
                    }));
                });
        });
    }

    render() {
        return <div className={style.component}>
            <div className={style.controls}>
                <Button onClick={this.showChooseFileDialog.bind(this, true)}>Добавить</Button>
            </div>
            {
                this.state.chooseFileDialogIsShowing
                && <ChooseFileDialog onClose={this.showChooseFileDialog.bind(this, false)}
                                     upload={this.upload.bind(this)}
                                     isUploading={this.state.isUploading}
                                     error={this.state.errorUpload}/>
            }
            {
                this.state.isLoading
                    ? <Spin/>
                    : this.state.error
                        ? <SimpleError error={this.state.error}/>
                        : <table className={`${tblStyle.table} ${style.table}`}>
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>тип</th>
                                    <th/>
                                </tr>
                            </thead>
                            <tbody>
                                {
                                    this.state.data
                            && this.state.data.info
                            && Object.entries(this.state.data.info)
                                .map((item: any[], index) => {
                                    return <tr key={index}>
                                        <td>{++index}</td>
                                        <td>{item[0]}</td>
                                        <td>{item[1].reserved}/{item[1].all}</td>
                                    </tr>;
                                })
                                }
                            </tbody>

                        </table>
            }
        </div>;
    }
}

interface IChooseFileDialogProps {
    onClose: () => void;
    upload: (data: any) => void;
    isUploading: boolean;
    error: any;
}

class ChooseFileDialog extends React.Component<IChooseFileDialogProps> {
    state = {
        error: null,
        rez: [],
        info: {},
        isUploading: false,
    };

    openFile() {
        const file: HTMLInputElement = document.createElement('input');
        file.type = 'file';
        file.style.display = 'none';
        document.body.appendChild(file);
        file.click();

        return new Promise((resolve, reject) => {
            file.onchange = (e: any) => {

                const reader = new FileReader();
                reader.onload = (event: any) => {
                    const contents = event.target.result;
                    resolve(contents);
                };

                reader.onerror = (event: any) => {
                    reject(event.target);
                };

                reader.readAsText(e.target.files[0]);
            };
        });
    }

    parse(data) {
        const positions = {};
        const rez = data
            .replace(/\r\n/ig, '\r')
            .replace(/\n/ig, '\r')
            .split('\r')
            .filter(item => item)
            .map(item => item.replace(/[,|;]/ig, ';')
                .split(';'))
            .reduce((_p, _c, _i, _a) => {
                if (_i == 0) { //read headers
                    _c.forEach((item, index) => {
                        positions[index] = item;
                    });
                } else {
                    const obj: any = {};
                    _c.forEach((item, index) => {
                        !!item.trim() && (obj[positions[index]] = item);
                    });

                    return [..._p, obj];
                }

                return _p;
            }, []);
        const info = rez.reduce((_p, _c) => {
            if (!_p.hasOwnProperty(_c.type)) {
                _p[_c.type] = [_c];
            } else {
                _p[_c.type].push(_c);
            }

            return _p;
        }, {});

        return [rez, info];
    }

    handle() {
        this.openFile()
            .then(data => {
                const [rez, info] = this.parse(data);
                this.setState(produce(this.state, draft => {
                    draft.error = null;
                    draft.rez = rez;
                    draft.info = info;
                }));
            })
            .catch(error => {
                this.setState(produce(this.state, draft => {
                    draft.error = error;
                }));
            });
    }

    upload() {
        this.props.upload(this.state.rez);
    }

    render() {
        return <Window onClose={this.props.onClose.bind(this)}
                       error={this.state.error || this.props.error}
                       title={'Внешние промокоды'}>
            <Button onClick={this.handle.bind(this)} disabled={this.props.isUploading}>Файл</Button>
            <div className={style.codes}>
                <strong>Всего промо: </strong> {this.state.rez && this.state.rez.length}
                <ul>
                    {
                        this.state.info
                        && this.state.info
                        && Object.entries(this.state.info).map((el: any[], index) => {
                            return <li key={index}><span className={`${style.promo_type} ${style[el[0]] || ''}`}>
                                {el[0]}:</span> {el[1].length}</li>;
                        })
                    }
                </ul>
            </div>
            <Button className={style.right}
                    disabled={!this.state.rez.length}
                    colorType={ButtonTypes.positive}
                    isLoading={this.props.isUploading}
                    onClick={this.upload.bind(this)}>
                Загрузить
            </Button>
        </Window>;
    }

}
