import * as React from 'react';

import { Dict } from '../../../../../types';
import { EMPTY_DATA } from '../../../../constants';
import { Link } from '../../../../ui/Link';
import * as virtualTreeStyle from '../../../../ui/VirtualTreeList/index.css';
import { Copy } from '../../../Copy';
import { VARIABLE_SEPARATOR } from '../constants';
import { ISettingsTree } from '../types';
import * as style from './index.css';

const TREE_ITEM_MARGIN = 2;
const TREE_ITEM_EXTRA_BORDER_MARGIN = 0.1;
export const MAX_VALUE_LENGTH = 100;

interface ITagTreeListItemProps {
    _style: Dict<any> ;
    onItemClick: () => void;
    index: number;
    item: ISettingsTree;
    collapsedIds: Dict<boolean>;
    openAddGlobalVarModal: () => void;
    filterValue: string;
    showPropositions: boolean;
}

export const GlobalVarsTreeListItem = React.memo((props: ITagTreeListItemProps) => {

    const getFilteredString = (field: string) => {
        const { filterValue = '' } = props;

        const filterFoundedIndex: number = field.toLowerCase().indexOf(filterValue.toLowerCase());

        return filterFoundedIndex > -1
            ? <span>
                {field.substring(0, filterFoundedIndex)}
                <span className={style.founded}>
                    {field.substring(filterFoundedIndex, filterFoundedIndex + filterValue.length)}
                </span>
                {field.substring(filterFoundedIndex + filterValue.length)}
            </span>
            : field || EMPTY_DATA;
    };

    const { item, _style, onItemClick, openAddGlobalVarModal, collapsedIds, showPropositions } = props;
    const fullId = item.setting_key;
    const id = fullId.split(VARIABLE_SEPARATOR)[fullId.split(VARIABLE_SEPARATOR).length - 1];
    const setting_value = item.setting_value;
    const meta = item.meta;
    const { nestingLevel = 0 } = meta || {};
    const itemStyle = Object.assign({}, _style,
        {
            marginLeft: `${nestingLevel * TREE_ITEM_MARGIN + TREE_ITEM_EXTRA_BORDER_MARGIN}em`,
            width: `calc(100% - ${nestingLevel * TREE_ITEM_MARGIN + TREE_ITEM_EXTRA_BORDER_MARGIN}em)`,
        });

    const path = item.setting_key;
    const href = `#/settings/global-vars/${path}`;
    const itemInitialData = showPropositions
        ? item
        : { setting_key: path, setting_value, revision: item.revision, propositions: item.propositions };

    const idField = getFilteredString(id);

    return <div className={style.tree_node_container} style={itemStyle} onClick={onItemClick.bind(null, fullId)}>
        <div className={`${style.tree_node}`
        + ` ${!item?.children?.length ? style.no_children : ''}`
        + ` ${setting_value ? style.with_value : ''}`}>
            {item?.children?.length
                ? <div className={`${virtualTreeStyle.node_arrow} ${collapsedIds[fullId]
                    ? virtualTreeStyle.opened
                    : ''}`}>▶</div>
                : <div/>}
            <div className={style.variable_name}>
                {setting_value
                    ? <Link onClick={openAddGlobalVarModal.bind(null, itemInitialData, false)}
                            href={`${href}${showPropositions ? '/proposition' : ''}`}
                            disablePreventDefault>
                        {idField}
                    </Link>
                    : <span>{idField}</span>}
                {!showPropositions &&
                    <Link onClick={openAddGlobalVarModal.bind(null, { setting_key: `${path}${VARIABLE_SEPARATOR}` })}
                          className={style.add_value_icon}>+</Link>}
                {item?.propositions?.length
                    ? <Link href={`${href}/proposition`} className={style.link}>
                        Предложение
                    </Link>
                    : null}
                {showPropositions && setting_value
                    ? <Copy text={`${location.origin}${location.pathname}${href}/proposition`}
                            className={`${style.link} ${style.copy}`}>
                        Копировать ссылку
                    </Copy>
                    : null}
            </div>
            {setting_value
                ? <div className={style.variable_value}>
                    {setting_value.length > MAX_VALUE_LENGTH
                        ? `${setting_value?.slice(0, MAX_VALUE_LENGTH)}...`
                        : setting_value}
                </div>
                : null}
        </div>
    </div>;
});
