import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS = {
    GET_GLOBAL_SETTINGS: 'GET_GLOBAL_SETTINGS',
    UPSERT_SETTINGS: 'UPSERT_SETTINGS',
    REMOVE_SETTINGS: 'REMOVE_SETTINGS',
    GET_SETTINGS_HISTORY: 'GET_SETTINGS_HISTORY',
    SETTINGS_PROPOSE: 'SETTINGS_PROPOSE',
    SETTINGS_REJECT: 'SETTINGS_REJECT',
    SETTINGS_CONFIRM: 'SETTINGS_CONFIRM',
};

export const GLOBAL_VARS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_GLOBAL_SETTINGS]: {
        api: 'settings/info',
    },
    [REQUESTS.UPSERT_SETTINGS]: {
        method: REQUEST_METHOD.POST,
        api: 'settings/upsert',
    },
    [REQUESTS.REMOVE_SETTINGS]: {
        method: REQUEST_METHOD.POST,
        api: 'settings/remove',
    },
    [REQUESTS.GET_SETTINGS_HISTORY]: {
        api: 'settings/history',
    },
    [REQUESTS.SETTINGS_PROPOSE]: {
        method: REQUEST_METHOD.POST,
        api: 'settings/propose',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.SETTINGS_REJECT]: {
        method: REQUEST_METHOD.POST,
        api: 'settings/reject',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.SETTINGS_CONFIRM]: {
        method: REQUEST_METHOD.POST,
        api: 'settings/confirm',
        cgiObj: {
            comment: null,
        },
    },
};
