export interface ISettingsItem {
    setting_key: string;
    setting_value: string;
    revision?: string;
    propositions?: IPropositionItem[];
}

export interface IPropositionItem {
    setting_key: string;
    setting_value: string;
    revision?: string;
    proposition_author: string;
    proposition_description: string;
    proposition_id: string;
}

export interface ISettingsTree {
    children?: ISettingsTree[];
    meta?: {
        nestingLevel: number;
        parentsIds: string[];
    };
    setting_key: string;
    setting_value: string | null;
    revision?: string;
    propositions?: IPropositionItem[];
}
