import React from 'react';

import { Window } from '../../../../ui/FullModal';
import { Copy } from '../../../Copy';
import style from '../style.css';

interface IInfoModalProps {
    onClose: () => void;
}

export const InfoModal = React.memo((props: IInfoModalProps) => {
    const whiteText = '[color=#FFFFFF]Текст[/color]';
    const boldText = '[b]Жирный текст[/b]';
    const link = '[url=https://yandex.ru/poll/enter/PwdPc9qGVwpRKD8sWhRPY9]Текст ссылки[/url]';

    return <Window onClose={props.onClose.bind(null)} title={'Подсказки'} className={style.info}>
        <h4>Название интроскрина</h4>
        <div>
            <div>ID интроскрина вводится в формате "Сокращенное название череди + номер тикета"."краткое описание".
            </div>
            <div>Пример: DA-1999.novice_discount_20pct_not_ride</div>
        </div>

        <h4>Редактирование текста</h4>
        <div>
            <div>Для редактирования текста испльзуется bb-code.</div>
            <div>Например, эта строка будет белого цвета - <Copy text={whiteText}>{whiteText}</Copy></div>
            <div>Тегом [b] можно настроить жирность - пример: <Copy text={boldText}>{boldText}</Copy></div>
        </div>

        <h4>Создание ссылок</h4>
        <div>Пример - <Copy text={link}>{link}</Copy></div>
    </Window>;
});
