import React, { useEffect, useState } from 'react';

import { useRequestHandler } from '../../../../hooks/useRequestHandler';
import { IOptionInfo } from '../../../../ui/Select';
import { isValidJSONString } from '../../../../utils/isValidJSONString';
import { Request2 } from '../../../../utils/request';
import { FormConstructor } from '../../../FormConstructor';
import { REQUESTS,SETTINGS_REQUESTS } from '../requests';
import style from '../style.css';
import { getContentSchema, LANDING_CONFIG_SCHEMA } from './schema';

interface ISimplifiedFormsProps {
    setContentFormValues: () => void;
    setOptionsFormValues: () => void;
    landing: Record<string, any>;
    chat: Record<string, any>;
}

export const SimplifiedForms = React.memo((props: ISimplifiedFormsProps) => {
    const [appLinkOptions, setOptions] = useState<IOptionInfo[]>([]);
    const PREFIX = 'chats.app_links';
    const request = new Request2({ requestConfigs: SETTINGS_REQUESTS });

    const requestOptions = React.useMemo(() => {
        return {
            requestName: REQUESTS.GET_GLOBAL_SETTINGS,
            requestOptions: {
                queryParams: {
                    prefix: PREFIX,
                },
            },
        };
    }, []);

    const responseHandler = (response) => {
        const stringValue = response?.settings?.[0]?.setting_value;
        const appLinkOptions: IOptionInfo[] = isValidJSONString(stringValue) ? JSON.parse(stringValue) : [];

        setOptions(appLinkOptions);
    };

    const [, , , makeResponse] = useRequestHandler(request, requestOptions, responseHandler);

    useEffect(() => {
        makeResponse();
    }, []);

    const { setContentFormValues, setOptionsFormValues, chat, landing } = props;

    return <div>
        <div>
            <h4>Содержание</h4>
            <FormConstructor schema={getContentSchema(appLinkOptions)}
                             initialData={chat}
                             hideChanges={true}
                             onChange={setContentFormValues.bind(null)}/>
        </div>

        <div className={style.landing_form}>
            <h4>Параметры запуска</h4>
            <FormConstructor schema={LANDING_CONFIG_SCHEMA}
                             initialData={landing}
                             hideChanges={true}
                             onChange={setOptionsFormValues.bind(null)}/>
        </div>
    </div>;
});
