import { controlType, SchemaItemVisual } from '../../../FormConstructor/types';
import { PRE_ACTION_MESSAGE_TYPE } from '../../ChatsEditor/constants';

export function getContentSchema(variants) {
    return {
        id: {
            type: controlType.string,
            display_name: 'id формата "DE-111.description"',
            required: true,
            description: 'ID интроскрина вводится в формате "сокращенное название тикета"."краткое описание"',
        },
        __introScreenType: {
            type: controlType.variable,
            control_field: {
                action_type: {
                    variants: ['context_buttons', 'deeplink'],
                    type: controlType.variants,
                    display_name: 'Тип действия',
                    description: 'Тип действия, которое пользователь должен выполнить в этом чате',
                    default: 'context_buttons',
                    editable: true,
                },
            },
            variants_fields: {
                deeplink: {
                    action_button_text: {
                        type: controlType.string,
                        display_name: 'Текст кнопки',
                        description: 'Текст, который будет написан на кнопке',
                    },
                    link: {
                        type: controlType.variants,
                        display_name: 'Ссылка в приложении',
                        editable: true,
                        variants,
                    },
                },
                context_buttons: {
                    schema: {
                        type: controlType.structure,
                        structure: {
                            type: {
                                type: controlType.variants,
                                variants: ['options'],
                                display_name: 'Тип элемента схемы',
                                default: 'options',
                                read_only: true,
                            },
                            options: {
                                display_name: 'Массив опций',
                                type: controlType.array_types,
                                array_type: {
                                    type: {
                                        type: controlType.variants,
                                        variants: ['message', 'deeplink'],
                                        display_name: 'Тип элемента схемы',
                                        default: 'deeplink',
                                        editable: true,
                                    },
                                    text: {
                                        type: controlType.string,
                                        display_name: 'Текст',
                                    },
                                    link: {
                                        type: controlType.variants,
                                        display_name: 'Ссылка',
                                        description: 'Только для deeplink',
                                        editable: true,
                                        variants,
                                    },
                                },
                            },
                        },
                        display_name: 'Схема',
                    },
                },
            },
        },
        pre_action_messages: {
            type: controlType.array_types,
            array_type: {
                type: controlType.variable,
                control_field: {
                    type: {
                        variants:
                            [
                                PRE_ACTION_MESSAGE_TYPE.PLAIN_TEXT,
                                PRE_ACTION_MESSAGE_TYPE.IMAGE,
                                PRE_ACTION_MESSAGE_TYPE.WELCOME_TEXT,
                            ],
                        type: controlType.variants,
                        multi_select: false,
                        display_name: 'Тип сообщения',
                        default: 'plaintext',
                        editable: true,
                    },
                },
                default_fields: {
                    text: {
                        type: controlType.text, display_name: 'Текст',
                    },
                },
                variants_fields: {
                    image: {
                        text: {
                            type: controlType.string,
                            display_name: 'Ссылка на изображение',
                            visual: SchemaItemVisual.FILE,
                        },
                    },
                },
            },
            required: true,
            display_name: 'Сообщения',
            description: 'Сообщения, которые надо отправить в чат от имени робота по заходу в эту вершину графа',
        },
    };
}

export const LANDING_CONFIG_SCHEMA = {
    landing_deadline: {
        type: controlType.numeric,
        visual: SchemaItemVisual.TIMESTAMP,
        display_name: 'Дедлайн',
    },
    landing_enabled: {
        type: controlType.bool,
        display_name: 'Активный',
    },
    landing_geo_tags: {
        type: controlType.variants,
        variants: [
            'msc_area',
            'spb_area',
            'kazan_area',
            'sochi_area',
        ],
        multi_select: true,
        display_name: 'Гео теги',
        editable: true,
    },
    landing_priority: {
        type: controlType.numeric,
        display_name: 'Приоритет',
    },
    android_min_app_build: {
        type: controlType.numeric,
        display_name: 'Минимальная версия Android, может быть отрицательной',
        default: 0,
        required: true,
    },
    ios_min_app_build: {
        type: controlType.numeric,
        display_name: 'Минимальная версия iOS, может быть отрицательной',
        default: 0,
        required: true,
    },

    landing_preview_separator: {
        type: controlType.separator,
        display_name: 'Превью интроскрина',
    },
    landing_chat_enabled: {
        type: controlType.bool,
        display_name: 'Показывать в превью',
    },
    landing_chat_title: {
        type: controlType.string,
        display_name: 'Заголовок превью ИC (макс. 60 символов)',
        maxLength: 60,
    },
    landing_preview: {
        type: controlType.string,
        display_name: 'Картинка-превью для интроскрина',
    },
    landing_timestamp_override: {
        type: controlType.numeric,
        display_name: 'Дата для отображения на превью интроскрина',
        visual: SchemaItemVisual.TIMESTAMP,
    },
    landing_chat_deadline: {
        type: controlType.numeric,
        display_name: 'Дата ухода из превью',
        description: 'Дата, когда интроскрин перестанет отображаться в приложении',
        visual: SchemaItemVisual.TIMESTAMP,
    },
};
