import React, { useState } from 'react';

import { Button } from '../../../ui/Button';
import { IntroscreenTest } from './IntroscreenTest/component';
import style from './style.css';

interface IIntroscreenSimplifiedProps {
}

enum EntityType {
    introscreen = 'introscreen',
    warning = 'warning',
}

export const IntroscreenSimplified = React.memo((props: IIntroscreenSimplifiedProps) => {
    const [selectedEntity, setSelectedEntity] = useState<keyof EntityType | string>('');

    return !selectedEntity
        ? <div className={style.start_screen}>
            <div className={style.choose_wrapper}>
                <div className={style.title}>
                    С чем будем работать?
                </div>

                <div className={style.buttons}>
                    <Button basic={true}
                            onClick={setSelectedEntity.bind(null, EntityType.introscreen)}>
                        Интроскрин
                    </Button>

                    <Button basic={true}
                            disabled={true}
                            onClick={setSelectedEntity.bind(null, EntityType.warning)}>
                        Ворнинг
                    </Button>
                </div>
            </div>
        </div>
        : selectedEntity === EntityType.introscreen
            ? <IntroscreenTest/>
            : null;
});
