import { combineRequests, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS: { [key: string]: string } = combineRequests(
    {
        GET_NOTIFIERS: 'GET_NOTIFIERS',
        UPSERT_NOTIFIERS: 'UPSERT_NOTIFIERS',
        UPSERT_LANDING: 'UPSERT_LANDING',
        GET_LANDINGS: 'GET_LANDINGS',
        GET_TAGS: 'GET_TAGS',
        GET_GLOBAL_SETTINGS: 'GET_GLOBAL_SETTINGS',
    },
);

export const SETTINGS_REQUESTS: IComponentRequest = combineRequests({
    [REQUESTS.GET_NOTIFIERS]: {
        api: 'notifiers/info',
        cgiObj: {
            ids: null,
        },
    },
    [REQUESTS.UPSERT_NOTIFIERS]: {
        api: 'notifiers/upsert',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.UPSERT_LANDING]: {
        method: REQUEST_METHOD.POST,
        api: 'landing/upsert',
    },
    [REQUESTS.GET_LANDINGS]: {
        api: 'landing/get',
        cgiObj: {
            id: null,
        },
    },
    [REQUESTS.GET_TAGS]: {
        api: 'tag/description/list',
    },
    [REQUESTS.GET_GLOBAL_SETTINGS]: {
        api: 'settings/info',
        cgiObj: {
            prefix: null,
        },
    },
});
