import moment from 'moment';
import React from 'react';

import { ONE_SECOND } from '../../../../constants';
import { isObjectEqual } from '../../../../utils/isObjectEqual';
import { ILanding } from '../types';
import * as styles from './index.css';

interface IPreviewPreviewProps {
    landing: ILanding | null;
}

export class PreviewPreview extends React.Component<IPreviewPreviewProps> {
    constructor(props) {
        super(props);
    }

    shouldComponentUpdate(
        nextProps: Readonly<IPreviewPreviewProps>,
        nextState: Readonly<any>,
        nextContext: any,
    ): boolean {
        return !isObjectEqual(nextProps, this.props) || !isObjectEqual(nextState, this.state);
    }

    render() {
        const { landing_chat_title, landing_preview, landing_timestamp_override } = this.props?.landing || {};
        const style = { '--bg-i': `url(${landing_preview})` } as React.CSSProperties;

        return <div style={style} className={`${styles.component} ${!landing_preview ? styles.border : ''}`}>
            <div className={styles.title}>
                {landing_chat_title}
            </div>
            <div className={styles.date}>
                {landing_timestamp_override
                    && moment(landing_timestamp_override * ONE_SECOND)
                        .locale('ru')
                        .format('DD MMMM')}
            </div>
        </div>;
    }
}
