import { Dict } from '../../../../../types';
import { controlType, ISchemaItem, SchemaItemVisual } from '../../../FormConstructor/types';

export const USER_LANDING_TAG_TYPE = 'user_landing';

export const LANDING_CONFIG_SCHEMA_MAIN: Dict<ISchemaItem> = {
    landing_id: { type: controlType.string, required: true, display_name: 'ID интроскрина', order: 1 },
    landing_priority: { type: controlType.numeric, display_name: 'Приоритет', order: 13 },
    landing_geo_tags: {
        type: controlType.variants,
        variants: [
            'msc_area',
            'spb_area',
            'kazan_area',
            'sochi_area',
        ],
        multi_select: true,
        display_name: 'Гео теги',
        order: 14,
        editable: true,
    },
    landing_deadline: {
        type: controlType.numeric,
        visual: SchemaItemVisual.TIMESTAMP,
        display_name: 'Дедлайн',
        order: 2,
    },
    landing_enabled: { type: controlType.bool, display_name: 'Активный', order: 3 },
    landing_check_auditory_condition_in_list: {
        type: controlType.bool, display_name: 'Проверка при загрузке истории chat/list', order: 3,
    },
    landing_chat_icon: { type: controlType.string, display_name: 'Иконка чата', order: 15 },
    landing_chat_id: { type: controlType.string, display_name: 'ID чата', order: 4 },
    landing_chat_messages_group: { type: controlType.string, display_name: 'ID ноды', order: 5 },
    landing_preview_separator: { type: controlType.separator, display_name: 'Превью интроскрина', order: 6 },
    landing_chat_title: {
        type: controlType.string,
        display_name: 'Заголовок превью интроскрина (максимум 60 символов)',
        maxLength: 60,
        order: 8,
    },
    landing_preview: { type: controlType.string, display_name: 'Картинка-превью для интроскрина', order: 9 },
    landing_timestamp_override: {
        type: controlType.numeric,
        display_name: 'Дата для отображения на превью интроскрина',
        visual: SchemaItemVisual.TIMESTAMP,
        order: 10,
    },
    landing_chat_deadline: {
        type: controlType.numeric,
        display_name: 'Дата ухода из превью',
        description: 'Дата, когда интроскрин перестанет отображаться в приложении',
        visual: SchemaItemVisual.TIMESTAMP,
        order: 11,
    },
    landing_chat_enabled: { type: controlType.bool, display_name: 'Показывать в превью', order: 7 },
    landing_json_substitute: {
        type: controlType.bool,
        display_name: 'Для платных дорог с подменой параметров',
        order: 7,
    },
    landing_event_tag_name: { type: controlType.string, display_name: 'Тег события', order: 7 },
    landing_preview_separator_end: { type: controlType.separator, order: 12 },
    landing_auditory_condition: { type: controlType.json, display_name: 'Landing auditory condition', order: 16 },
    patch_payload: { type: controlType.json, display_name: 'Patch payload', order: 17 },
    revision: {
        read_only: true,
        type: controlType.numeric,
        display_name: 'revision',
        order: 99,
    },
};

const BUTTON_TYPES = ['verify_user_selfie', 'continue', 'close', 'support', 'backend_handler', 'hide'];
const BUTTON_STYLES = ['solid', 'bordered'];

export const LANDING_CONFIG_SCHEMA_JSON: Dict<ISchemaItem> = {
    landing_json: {
        display_name: 'JSON',
        type: controlType.structure,
        structure: {
            title: {
                display_name: 'Заголовок',
                order: 1,
                type: controlType.text,
            },
            type: {
                order: 2,
                display_name: 'Тип',
                type: controlType.string,
            },
            is_closable: {
                order: 3,
                display_name: 'Закрываемый',
                type: controlType.bool,
            },
            color1: {
                order: 4,
                display_name: 'Цвет 1',
                type: controlType.string,
                visual: SchemaItemVisual.COLOR,
            },
            color2: {
                order: 5,
                display_name: 'Цвет 2',
                type: controlType.string,
                visual: SchemaItemVisual.COLOR,
            },
            transparence1: {
                order: 6,
                type: controlType.numeric,
                display_name: 'Прозрачность 1',
            },
            transparence2: {
                order: 7,
                type: controlType.numeric,
                display_name: 'Прозрачность 2',
            },
            points: {
                type: controlType.array_types,
                order: 8,
                array_type: {
                    type: controlType.text,
                    display_name: 'Элементы',
                },
                display_name: 'Элемент',
            },
            button: {
                order: 9,
                display_name: 'Текст кнопки',
                type: controlType.text,
            },
            button_type: {
                order: 10,
                display_name: 'Тип кнопки',
                type: controlType.variants,
                variants: BUTTON_TYPES,
                editable: true,
            },
            button_color: {
                order: 11,
                display_name: 'Цвет кнопки',
                type: controlType.string,
                visual: SchemaItemVisual.COLOR,
                default: '#fff',
            },
            button_style: {
                order: 12,
                display_name: 'Стиль кнопки',
                type: controlType.variants,
                variants: BUTTON_STYLES,
                editable: true,
                default: 'solid',
            },
            other_buttons: {
                order: 13,
                display_name: 'Дополнительные кнопки',
                type: controlType.array_types,
                array_type: {
                    button: {
                        order: 1,
                        display_name: 'Текст дополнительной кнопки',
                        type: controlType.text,
                    },
                    button_type: {
                        order: 2,
                        display_name: 'Тип дополнительной кнопки',
                        type: controlType.variants,
                        variants: BUTTON_TYPES,
                        editable: true,
                    },
                    button_color: {
                        order: 3,
                        display_name: 'Цвет дополнительной кнопки',
                        type: controlType.string,
                        visual: SchemaItemVisual.COLOR,
                        default: '#fff',
                    },
                    button_style: {
                        order: 4,
                        display_name: 'Стиль дополнительной кнопки',
                        type: controlType.variants,
                        variants: BUTTON_STYLES,
                        editable: true,
                        default: 'bordered',
                    },
                    button_meta: {
                        order: 5,
                        display_name: 'button_meta',
                        type: controlType.json,
                    },
                },
            },
        },
    },
};

export const LANDING_CONFIG_CLEAR: Dict<any> = {
    landing_id: '',
    landing_priority: 0,
    landing_geo_tags: [],
    landing_deadline: 0,
    landing_enabled: false,
    landing_check_auditory_condition_in_list: false,
    landing_json: {},
    landing_chat_id: '',
    landing_chat_messages_group: '',
    patch_payload: {},
    landing_auditory_condition: {},
    landing_event_tag_name: null,
};

export const LANDING_CONFIG_CLEAR_JSON: Dict<any> = {
    landing_json: {
        title: '',
        type: '',
        is_closable: false,
        color1: '',
        color2: '',
        transparence1: 0,
        transparence2: 0,
        points: [],
        button: '',
        button_type: '',
        button_color: '',
        button_style: '',
        other_buttons: [],
    },
};
