import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS = {
    GET_LANDINGS: 'GET_LANDINGS',
    GET_TAGS: 'GET_TAGS',
    GET_ACTIONS: 'GET_ACTIONS',
    UPSERT_LANDING: 'UPSERT_LANDING',
    REMOVE_LANDING: 'REMOVE_LANDING',
    CLEAR_LANDING_HISTORY: 'CLEAR_LANDING_HISTORY',
    ATTACH_USER_TAG: 'ATTACH_USER_TAG',
    GET_USERS_BY_ROLE: 'GET_USERS_BY_ROLE',
    ADD_ACTION: 'ADD_ACTION',
    PROPOSE_LANDING: 'PROPOSE_LANDING',
    PROPOSITION_CONFIRM: 'PROPOSITION_CONFIRM',
    PROPOSITION_REJECT: 'PROPOSITION_REJECT',
};

export const LANDINGS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_LANDINGS]: {
        api: 'landing/get',
        cgiObj: {
            id: null,
        },
    },
    [REQUESTS.GET_TAGS]: {
        api: 'tag/description/list',
    },
    [REQUESTS.UPSERT_LANDING]: {
        method: REQUEST_METHOD.POST,
        api: 'landing/upsert',
    },
    [REQUESTS.REMOVE_LANDING]: {
        method: REQUEST_METHOD.POST,
        api: 'landing/remove',
    },
    [REQUESTS.CLEAR_LANDING_HISTORY]: {
        api: 'landing/clear',
        cgiObj: {
            user_id: null,
            id: null, //comma separated landings ids list
        },
    },
    [REQUESTS.ATTACH_USER_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'user_tags/add',
    },
    [REQUESTS.GET_USERS_BY_ROLE]: {
        api: 'roles/users',
        cgiObj: {
            roles: null,
            page: null,
            page_size: null,
        },
    },
    [REQUESTS.ADD_ACTION]: {
        method: REQUEST_METHOD.POST,
        api: 'actions/add',
    },
    [REQUESTS.PROPOSE_LANDING]: {
        method: REQUEST_METHOD.POST,
        api: `landing/propose`,
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.PROPOSITION_CONFIRM]: {
        method: REQUEST_METHOD.POST,
        api: 'landing/confirm',
        cgiObj: {
            comment: null,
            proposition_ids: null,
        },
    },
    [REQUESTS.PROPOSITION_REJECT]: {
        method: REQUEST_METHOD.POST,
        api: 'landing/reject',
        cgiObj: {
            comment: null,
            proposition_ids: null,
        },
    },
    [REQUESTS.GET_ACTIONS]: {
        api: 'actions/list',
    },
};
