import { Dict } from '../../../../types';

export const SCREEN_PREVIEW_WIDTH = 300;

interface ILandingJson {
    title?: string;
    type?: string;

    color1?: string;
    color2?: string;

    transparence1?: number;
    transparence2?: number;

    button?: string;
    button_type?: string;
    button_color?: string;
    button_style?: string;

    is_closable?: boolean;

    other_buttons?: {
        button: string;
        button_type: string;
        button_color: string;
        button_style: string;
    }[];

    points?: string[];
}

export interface ILanding {
    landing_priority: number;
    landing_id: string;
    landing_json: ILandingJson;
    landing_enabled: boolean;
    landing_deadline?: number;
    landing_auditory_condition?: Dict<any>;
    landing_geo_tags?: any;
    landing_chat_id?: string;
    landing_chat_messages_group?: string;
    landing_chat_title?: string;
    landing_preview?: string;
    landing_chat_deadline?: number;
    landing_chat_enabled?: boolean;
    landing_timestamp_override?: number;
    landing_json_substitute?: boolean;
    landing_event_tag_name?: string;

    proposition_id?: string;
    proposition_description?: string;
}
