import React from 'react';

import { ONE_SECOND } from '../../../constants';
import { Cross } from '../../../ui/Cross';
import FormatDate from '../../../ui/FormatDate';
import { Copy } from '../../Copy';
import styles from './index.css';

export interface IMdsItem {
    key: string;
    link: string;
    modification_time: number;
}

interface IMdsTableRowProps {
    img: IMdsItem;
    index: number;
    showRemoveModal: () => void;
    showImg: () => void;
    mdsTooltipId: string;
    style: any;
    startIndex: number;
}

const PADDING = 12;

const MdsTableRow = (props: IMdsTableRowProps) => {
    const { img, showRemoveModal, showImg, mdsTooltipId, style, index, startIndex } = props;

    return <>
        <div onClick={showImg}>📸</div>
        <div><FormatDate value={img.modification_time * ONE_SECOND}/></div>
        <div>
            <Copy text={img.link}
                  externalTooltipId={mdsTooltipId}
                  tooltipConfig={{
                      overridePosition: (position) => ({
                          left: position.left,
                          top: style?.top
                              ? (index !== startIndex ? style.top - PADDING : style.top + PADDING)
                              : PADDING,
                      }),
                      place: index !== startIndex ? 'top' : 'bottom',
                  }}>
                <span className={styles.copy_text}>{img.key}</span>
            </Copy>
        </div>
        <Cross onClick={showRemoveModal}/>
    </>;
};

export default MdsTableRow;
