import * as React from 'react';
import { useEffect, useState } from 'react';

import { IRequestQueueItem, useRequestQueueHandler } from '../../../../hooks/useRequestQueueHandler';
import { Request2 } from '../../../../utils/request';
import { IStore } from '../../../App/store';
import FileChooserDialog from '../../../FileChooserDialog';
import { REQUESTS, SETTINGS_REQUESTS } from '../../request';
import { prepareKeyToMDS } from '../prepareKeyToMDS';

const FILE_COUNT_LIMIT = 20;

interface IMdsUploadDialogProps extends IStore {
    onClose: () => void;
    error: Error | null;
    getData: () => void;
}

const request = new Request2({ requestConfigs: SETTINGS_REQUESTS });

export function MdsUploadDialog(props: IMdsUploadDialogProps) {
    const { onClose, error, getData } = props;
    const [requestOptions, setRequestOptions] = useState<IRequestQueueItem[]>([]);
    const [isLoading, response, , makeResponse, progressBarObj] = useRequestQueueHandler(request, requestOptions);

    useEffect(() => {
        if (response) {
            getData();
            if (progressBarObj.errors.length === 0) {
                onClose();
            }
        }
    }, [response]);

    const uploadFiles = (files: File[], inputNameArr: string[]) => {
        setRequestOptions([]);
        files.map((file, index) => {
            const key = prepareKeyToMDS(inputNameArr[index]);
            setRequestOptions(prev => {
                return [
                    ...prev,
                    {
                        requestName: REQUESTS.ADD_MDS_RESOURCES,
                        requestOptions: {
                            queryParams: {
                                key,
                            },
                            file: file,
                            headers: {
                                'Content-Type': 'image',
                            },
                        },
                    },
                ];
            });
        });

        makeResponse();
    };

    return (
        <FileChooserDialog onClose={onClose}
                           upload={uploadFiles}
                           isUploading={isLoading}
                           error={error}
                           onlyPDF={false}
                           fileCountLimit={FILE_COUNT_LIMIT}
                           withInput
                           progressBarObj={progressBarObj}/>
    );
}
