import * as React from 'react';

import { Confirm } from '../../../../ui/FullModal';
import { Request2 } from '../../../../utils/request';
import { REQUESTS, SETTINGS_REQUESTS } from '../../request';

interface IRemoveModelModalProps {
    onClose: () => void;
    modelToEdit: string;
    reloadData?: () => void;
}

interface IRemoveModelModalState {
    error: Error | null;
    isLoading: boolean;
}

export class RemoveModelModal extends React.Component<IRemoveModelModalProps, IRemoveModelModalState> {
    state: IRemoveModelModalState = {
        error: null,
        isLoading: false,
    };

    request = new Request2({ requestConfigs: SETTINGS_REQUESTS });

    sendData() {
        const { onClose, reloadData, modelToEdit } = this.props;

        this.setState({
            isLoading: true,
        }, () => {
            this.request.exec(REQUESTS.REMOVE_ML_MODEL,{
                body: {
                    name: modelToEdit,
                },
            })
                .then(() => {
                    onClose();
                    if (reloadData) {
                        reloadData();
                    }
                })
                .catch((error) => {
                    this.setState({
                        error,
                        isLoading: false,
                    });
                });
        });
    }

    render() {
        const { error, isLoading } = this.state;
        const { onClose, modelToEdit } = this.props;

        return (
            <Confirm question={`Удалить модель ${modelToEdit}?`}
                     error={error}
                     accept={this.sendData.bind(this)}
                     isWorking={isLoading}
                     onClose={onClose}/>
        );
    }
}
