import * as React from 'react';
import { Route, Switch } from 'react-router';

import { Button } from '../../../ui/Button';
import { Link } from '../../../ui/Link';
import * as tblStyles from '../../../ui/Table/index.css';
import { Request2 } from '../../../utils/request';
import { SimpleError } from '../../SimpleError';
import Spin from '../../Spin';
import { REQUESTS, SETTINGS_REQUESTS } from '../request';
import AddModelModal from './AddModelModal';
import * as styles from './index.css';
import RemoveModelModal from './RemoveModelModal';

interface IMLModelsProps {

}

interface IMLModelsState {
    error: Error | null;
    isLoading: boolean;
    data: string[];
    showRemoveModal: boolean;
    modelToEdit: string | null;
}

export class MLModels extends React.Component<IMLModelsProps, IMLModelsState> {
    state: IMLModelsState = {
        error: null,
        isLoading: false,
        data: [],
        showRemoveModal: false,
        modelToEdit: null,
    };

    request = new Request2({ requestConfigs: SETTINGS_REQUESTS });

    getData() {
        this.setState({
            isLoading: true,
        }, () => {
            this.request.exec(REQUESTS.GET_ML_MODELS)
                .then(response => {
                    const data = response && response.models || [];

                    this.setState({
                        data: data.sort((a, b) => a - b),
                        isLoading: false,
                    });
                })
                .catch(error => {
                    this.setState({
                        error,
                        isLoading: false,
                    });
                });
        });
    }

    showAddModal(modelId?) {
        location.href = `#/settings/ml-models/item${modelId ? `/${encodeURIComponent(modelId)}` : ''}`;
    }

    closeAddModal() {
        location.href = `#/settings/ml-models`;
    }

    showRemoveModal(value, model) {
        this.setState({
            showRemoveModal: value,
            modelToEdit: model,
        });
    }

    componentDidMount() {
        this.getData();
    }

    render() {
        const { error, isLoading, data, showRemoveModal, modelToEdit } = this.state;
        let {} = this.props;

        return error ? <SimpleError error={error} /> : isLoading ? <Spin /> : (
            <>
                <Switch>
                    <Route path={'/settings/ml-models/item/:modelId?'}
                           render={(props) => {
                               const modelId = props.match && props.match.params && props.match.params.modelId
                                && decodeURIComponent(props.match.params.modelId);

                               return (
                                   <AddModelModal modelId={modelId}
                                                  onClose={this.closeAddModal.bind(this)}
                                                  reloadData={this.getData.bind(this)}/>
                               );
                           }}/>
                </Switch>
                {showRemoveModal && (
                    <RemoveModelModal modelToEdit={modelToEdit}
                                      onClose={this.showRemoveModal.bind(this, false, null)}
                                      reloadData={this.getData.bind(this)}/>
                )}
                <Button onClick={this.showAddModal.bind(this, '')}>Добавить модель</Button>
                <h5 className={styles.title}>
                    Всего моделей: {data.length}
                </h5>
                <table className={tblStyles.table}>
                    <thead>
                        <tr>
                            <th>№</th>
                            <th>Название модели</th>
                            <th/>
                        </tr>
                    </thead>
                    <tbody>
                        {data && data.map((model, index) => {
                            return (
                                <tr key={index}>
                                    <td>{index + 1}</td>
                                    <td>
                                        <Link onClick={this.showAddModal.bind(this, model)}>
                                            {model}
                                        </Link>
                                    </td>
                                    <td>
                                        <Link onClick={this.showRemoveModal.bind(this, 'true', model)}>
                                        Удалить
                                        </Link>
                                    </td>
                                </tr>
                            );
                        })}
                    </tbody>
                </table>
            </>
        );
    }
}
