import { controlType } from '../../../FormConstructor/types';

export const MODEL_SCHEMA = {
    manufacturer: { type: controlType.string, display_name: 'manufacturer', order: 0 },
    code: { type: controlType.string, display_name: 'code', order: 1 },
    name: { type: controlType.string, display_name: 'name', order: 2 },
    short_name: { type: controlType.string, display_name: 'short_name', order: 3 },
    registry_manufacturer: { type: controlType.string, display_name: 'registry_manufacturer', order: 4 },
    registry_model: { type: controlType.string, display_name: 'registry_model', order: 5 },
    fuel_cap_side: { type: controlType.string, display_name: 'fuel_cap_side', order: 6 },
    fuel_type: { type: controlType.string, display_name: 'fuel_type', order: 7 },
    image_small_url: { type: controlType.string, display_name: 'image_small_url', order: 8 },
    image_large_url: { type: controlType.string, display_name: 'image_large_url', order: 9 },
    image_map_url: { type: controlType.string, display_name: 'image_map_url', order: 10 },
    image_map_url_2x: { type: controlType.string, display_name: 'image_map_url_2x', order: 11 },
    image_map_url_3x: { type: controlType.string, display_name: 'image_map_url_3x', order: 12 },
    image_pin_url_2x: { type: controlType.string, display_name: 'image_pin_url_2x', order: 13 },
    image_pin_url_3x: { type: controlType.string, display_name: 'image_pin_url_3x', order: 14 },
    video_url: { type: controlType.string, display_name: 'video_url', order: 15 },
    fuel_icon_url: { type: controlType.string, display_name: 'fuel_icon_url', order: 16 },
    fuel_distance_enabled: { type: controlType.bool, display_name: 'fuel_distance_enabled', default: false },
    image_angle_url: { type: controlType.string, display_name: 'image_angle_url', order: 18 },
    image_background_url: { type: controlType.string, display_name: 'image_background_url', order: 19 },
    rank: { type: controlType.numeric, display_name: 'rank', order: 20 },
    z_index: { type: controlType.numeric, display_name: 'z_index', order: 21, min: -9999, max: 9999 },
    visual: { type: controlType.json, display_name: 'visual', order: 21 },
    meta: { type: controlType.json, display_name: 'meta', order: 22 },
    maintenance_period: { type: controlType.string, display_name: 'Временной интервал между ТО (дни)', order: 23 },
    maintenance_mileage: { type: controlType.numeric, display_name: 'Пробег между обязательными ТО (км)', order: 23 },
    intermediate_maintenance_mileage: { type: controlType.numeric, display_name: 'Промежуточное ТО (км)', order: 23 },
    first_maintenance_mileage: { type: controlType.numeric, display_name: 'Нулевое ТО (км)', order: 23 },
};

export const CLEAR_SCHEMA = {
    manufacturer: '',
    code: '',
    name: '',
    short_name: '',
    registry_manufacturer: '',
    registry_model: '',
    fuel_cap_side: '',
    fuel_type: '',
    image_small_url: '',
    image_large_url: '',
    image_map_url: '',
    image_map_url_2x: '',
    image_map_url_3x: '',
    image_pin_url_2x: '',
    image_pin_url_3x: '',
    video_url: '',
    fuel_icon_url: '',
    fuel_distance_enabled: false,
    z_index: null,
    image_angle_url: '',
    image_background_url: '',
    rank: '',
    visual: {},
    meta: {},
    segment: '',
    maintenance_period: '',
    maintenance_mileage: '',
    intermediate_maintenance_mileage:'',
    first_maintenance_mileage: '',
};

export const MODEL_SPECIFICATION_SCHEMA = {
    id: { type: controlType.string, display_name: 'id', order: 0, read_only: true },
    sp_name: { type: controlType.string, display_name: 'Название спецификации', order: 1 },
    sp_value: { type: controlType.string, display_name: 'Значение спецификации', order: 2 },
    sp_position: { type: controlType.numeric, display_name: 'Позиция спецификации', order: 3 },
    icon: { type: controlType.string, display_name: 'icon', order: 4 },
};

export const MODEL_DEFAULT_TAG_SCHEMA = {
    tag_name: {
        order: 1,
        type: controlType.variants,
        multi_select: false,
        display_name: 'Тег',
        variants: [],
    },
    priority: { type: controlType.numeric, display_name: 'Приоритет', order: 2, default: 0 },
    comment: { type: controlType.string, display_name: 'Комментарий', order: 3 },
};

export const DEFAULT_TAG_PRIORITY_KEY = 'defaultTagsPriority';
