import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS = {
    GET_MODELS: 'GET_MODELS',
    UPDATE_MODEL: 'UPDATE_MODEL',
    REMOVE_MODEL: 'REMOVE_MODEL',
    ADD_MODEL_SPECIFICATION: 'ADD_MODEL_SPECIFICATION',
    REMOVE_MODEL_SPECIFICATION: 'REMOVE_MODEL_SPECIFICATION',
    GET_TAGS: 'GET_TAGS',
};

export const MODEL_EDITOR_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_MODELS]: {
        api: 'model/info',
        cgiObj: {
            id: null,
        },
    },
    [REQUESTS.UPDATE_MODEL]: {
        method: REQUEST_METHOD.POST,
        api: 'model/info',
    },
    [REQUESTS.REMOVE_MODEL]: {
        method: REQUEST_METHOD.POST,
        api: 'model/remove',
    },
    [REQUESTS.ADD_MODEL_SPECIFICATION]: {
        method: REQUEST_METHOD.POST,
        api: 'model_spec/add',
    },
    [REQUESTS.REMOVE_MODEL_SPECIFICATION]: {
        method: REQUEST_METHOD.POST,
        api: 'model_spec/remove',
    },
    [REQUESTS.GET_TAGS]: {
        api: 'tag/description/list',
    },
};
