import * as React from 'react';

import { Button } from '../../../ui/Button';
import { Collapse2 } from '../../../ui/Collapse2';
import { CopyIcon } from '../../../ui/CopyIcon';
import { Input } from '../../../ui/Input';
import { Link } from '../../../ui/Link';
import Select from '../../../ui/Select';
import { Request2 } from '../../../utils/request';
import { deepCopy, generateuuid4 } from '../../../utils/utils';
import { RESPONSE_STATUSES, SimpleError } from '../../SimpleError';
import { REQUESTS, SETTINGS_REQUESTS } from '../request';
import * as styles from './index.css';

interface INewUserState {
    isWorking: boolean;
    userInfo: {
        uid: string; username: string; first_name: string; last_name: string; pn: string; id?: string;
        email: string; phone: string; status: string;
    };
    editedFields: string[];
    error: Error | null;
}

export class NewUser extends React.Component<INewUserState> {
    state: INewUserState = {
        isWorking: false,
        userInfo: {
            uid: "",
            email: "",
            phone: "",
            status: "onboarding",
            username: "",
            first_name: "",
            last_name: "",
            pn: "",
        },
        editedFields: [],
        error: null,
    };
    request = new Request2({ requestConfigs: SETTINGS_REQUESTS });

    changeUid(value: string) {
        this.setState({
            uid: value,
        });
    }

    addUser() {
        this.setState({
            isWorking: true,
        }, () => {
            const user_id = generateuuid4();
            this.request.exec(REQUESTS.CHECK_USER, {
                queryParams: { user_id },
            })
                .then(() => {
                    this.setState({
                        error: new Error("Ошибка! Пользователь НЕ создан"),
                    });
                })
                .catch((error) => {
                    const userInfo = deepCopy(this.state.userInfo);
                    delete userInfo.uid;

                    error.response.status === RESPONSE_STATUSES.CODE_404
          && this.request.exec(REQUESTS.EDIT_USER, {
              body: Object.assign(userInfo,
                  { id: user_id },
                  this.state.userInfo.uid ? { uid: +this.state.userInfo.uid } : {}),
          })
              .then(() => {
                  this.setState({
                      isWorking: false,
                  });
              })
              .catch(() => {
                  this.setState({
                      isWorking: false,
                  });
              });
                });
        });
    }

    changeUserInfoInput(key: string, value: string) {
        const editedFields: string[] = [];

        const userInfo = this.state.userInfo;
        userInfo[key] = value.toString();
        if (key === "email") {
            userInfo["username"] = value.split("@")[0];
        }

        Object.entries(userInfo).map(entry => {
            const [key, value] = entry;
            if (value) {
                editedFields.push(key);
            }
        });

        this.setState({ userInfo, editedFields });
    }

    render() {
        const postfix = `/blackbox/?method=userinfo&login=login&sid=passport&userip=127.0.0.1`;
        const internal = `curl -v -s 'http://blackbox.yandex-team.ru${postfix}'`;
        const external = `curl -v -s 'http://blackbox.yandex.net${postfix}'`;

        return (
            <>
                {this.state.error && <SimpleError error={this.state.error} />}
                <div><i>
                    Что бы завести external-пользователя нужно заполнить email/phone и выбрать соответсвующий статус
                </i></div>
                <div className={styles.form}>
                    {Object.entries(this.state.userInfo).map(entry => {
                        const key: string = entry[0];
                        const value: any = entry[1];
                        if (key === "status") {
                            return <Select onSelect={this.changeUserInfoInput.bind(this, key)}
                                           key={key}
                                           placeholder={"status"}
                                           initialValues={[this.state.userInfo.status]}
                                           addingOddVariants
                                           options={[
                                               { text: "external", value: "external" },
                                               { text: "onboarding", value: "onboarding" },
                                               { text: "active", value: "active" },
                                           ]} />;
                        }

                        return (
                            <Input onChange={this.changeUserInfoInput.bind(this, key)}
                                   key={key}
                                   placeholder={key}
                                   value={value}/>
                        );
                    })}
                    <div className={styles.link_to_user}>
                        {this.state.userInfo?.id
                            ? <div>Пользователь: <Link href={`#/clients/${this.state.userInfo.id}/info-old`}>
                                {this.state.userInfo.id}
                            </Link>
                            </div>
                            : null}
                    </div>

                    <Button className={styles.button}
                            onClick={this.addUser.bind(this)}
                            disabled={this.state.isWorking || !this.state.editedFields.length}>Добавить UID</Button>
                    <Collapse2 title={"curl для получения UID по логину"}>
                        <h5>Без грантов не работает!!!</h5>
                        <ul>
                            <li><CopyIcon text={internal} /> для внутренних:
                                <pre>{internal}</pre>
                            </li>
                            <li><CopyIcon text={external} /> для внешних:
                                <pre>{external}</pre>
                            </li>
                        </ul>
                    </Collapse2>
                </div>
            </>
        );
    }
}
