import * as React from 'react';

import { EMPTY_DATA } from '../../../../constants';
import { JsonModal } from '../../../../ui/FullModal/JsonModal';
import { Link } from '../../../../ui/Link';
import { IPlaneTreeItem } from '../../../../ui/VirtualTreeList';
import { INotifier, NEW_ITEM_URL } from '../types';
import * as style from './index.css';

interface INotifierTreeListItemProps {
    item: IPlaneTreeItem<INotifier>;
    showPropositions?: boolean;
}

interface INotifierTreeListItemState {
    isMetaModalOpen: boolean;
}

export class NotifierTreeListItem extends React.Component<INotifierTreeListItemProps, INotifierTreeListItemState> {
    state: INotifierTreeListItemState = {
        isMetaModalOpen: false,
    };

    openMetaModal() {
        this.setState({ isMetaModalOpen: true });
    }

    closeMetaModal() {
        this.setState({ isMetaModalOpen: false });
    }

    render() {
        const { item , showPropositions } = this.props;
        const { data, meta } = item || {};
        const { name, revision, meta: dataMeta } = data;
        const { children, childrenCount, filteredChildrenCount } = meta;

        return <div className={style.tree_list_item}>
            <div className={style.id}>
                {children?.length
                    ? <span>{name}</span>
                    : <Link href={`#${NEW_ITEM_URL}${encodeURIComponent(data?.name)}`}>{name}</Link>}
                {children?.length
                    ? <span className={style.children_length}>
                        {filteredChildrenCount
                            ? filteredChildrenCount || null
                            : childrenCount || null}
                    </span>
                    : ''}
            </div>
            {revision && !showPropositions
                ? <div className={style.revision}>
                    Ревизия: {revision || EMPTY_DATA}
                </div>
                : null}
            {dataMeta
                ? <div className={style.meta}>
                    <Link onClick={this.openMetaModal.bind(this)}>Meta</Link>
                </div>
                : null}
            {this.state.isMetaModalOpen
                ? <JsonModal title={`Метаинформация нотификатора ${data?.name}`}
                             onClose={this.closeMetaModal.bind(this)}
                             obj={dataMeta}/>
                : null}
        </div>;
    }
}
