import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS = {
    GET_NOTIFIERS: 'GET_NOTIFIERS',
    REMOVE_NOTIFIERS: 'REMOVE_NOTIFIERS',
    UPSERT_NOTIFIERS: 'UPSERT_NOTIFIERS',
    GET_GLOBAL_SETTINGS: 'GET_GLOBAL_SETTINGS',
    NOTIFIERS_PROPOSE: 'NOTIFIERS_PROPOSE',
    NOTIFIERS_REJECT: 'NOTIFIERS_REJECT',
    NOTIFIERS_CONFIRM: 'NOTIFIERS_CONFIRM',
    GET_PROPOSITIONS: 'GET_PROPOSITIONS',
};

export const NOTIFIERS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_NOTIFIERS]: {
        api: 'notifiers/info',
        cgiObj: {
            ids: null,
        },
    },
    [REQUESTS.REMOVE_NOTIFIERS]: {
        api: 'notifiers/remove',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.UPSERT_NOTIFIERS]: {
        api: 'notifiers/upsert',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.NOTIFIERS_PROPOSE]: {
        method: REQUEST_METHOD.POST,
        api: 'notifiers/propose',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.NOTIFIERS_REJECT]: {
        method: REQUEST_METHOD.POST,
        api: 'notifiers/reject',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.NOTIFIERS_CONFIRM]: {
        method: REQUEST_METHOD.POST,
        api: 'notifiers/confirm',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.GET_PROPOSITIONS]: {
        api: 'notifiers/propositions',
    },
};
