import React, { useState } from 'react';

import { Dict } from '../../../../../types';
import { IRequestQueueItem, useRequestQueueHandler } from '../../../../hooks/useRequestQueueHandler';
import { Button, ButtonTypes } from '../../../../ui/Button';
import { Request2 } from '../../../../utils/request';
import { IProgressBarProps } from '../../../ProgressBar/types';
import { REQUESTS, TAG_REQUESTS } from '../../../TagModal/request';
import style from './index.css';

const PRIORITY_KEY = 'priority';
const TAG_KEY = 'tag';

const request = new Request2({ requestConfigs: TAG_REQUESTS });

interface IArea {
    areaId: string;
    hardTags: string;
}

interface IAddTagsToAreasProps {
    onClick: () => void;
    areas: IArea[];
    tag: Dict<any>;
    addTagToPolygons: boolean;
    updateProgressBar: (data: IProgressBarProps) => void;
    onClose: () => void;
    toggleAddTagToPolygons: () => void;
    updatePolygons: () => void;
}

export const AddTagsToAreas = (props: IAddTagsToAreasProps) => {
    const {
        onClick,
        areas,
        tag,
        addTagToPolygons,
        updateProgressBar,
        onClose,
        toggleAddTagToPolygons,
        updatePolygons,
    } = props;
    const [requestOptions, setRequestOptions] = useState<IRequestQueueItem[]>([]);
    const [, response, , makeResponse, progressBarObj] = useRequestQueueHandler(request, requestOptions);

    const formatTagData = (data: Dict<any>) => {
        data[PRIORITY_KEY] = +data[PRIORITY_KEY] || 0;
        data[TAG_KEY] = data?.[TAG_KEY]?.toString();

        return data;
    };

    React.useEffect(() => {
        if(areas?.length > 0 && addTagToPolygons) {
            setRequestOptions([]);
            areas.map((area, index) => {
                const data = Object.assign({}, formatTagData(tag), {
                    object_id: area.areaId,
                });

                setRequestOptions(prev => {
                    return [
                        ...prev,
                        {
                            requestName: REQUESTS.ATTACH_AREA_TAG,
                            requestOptions: {
                                queryParams: {
                                    object_id: area.areaId,
                                },
                                body: data,
                            },
                        },
                    ];
                });
            });

            makeResponse();
        }
    }, [addTagToPolygons]);

    React.useEffect(() => {
        updateProgressBar(progressBarObj);
    }, [progressBarObj]);

    React.useEffect(() => {
        if(response && !progressBarObj.errors.length) {
            onClose();
            updatePolygons();
        } else if(response) {
            toggleAddTagToPolygons();
            updatePolygons();
        }
    }, [response]);

    return (
        <Button colorType={ButtonTypes.positive}
                className={style.addTags}
                onClick={onClick}>+</Button>
    );
};
