import { RouterState } from 'connected-react-router';
import React from 'react';

import { Dict } from '../../../../../types';
import { Window } from '../../../../ui/FullModal';
import { AreaHistory } from './AreaHistory/component';
import { AreaTagsHistory } from './AreaTagsHistory/component';
import { CurrentAreaTags } from './CurrentAreaTags/component';

type IAreaInfoModalProps = RouterState

interface IAreaInfoModalState {
    areaId: string;
}

export class AreaInfoModal extends React.Component<IAreaInfoModalProps, IAreaInfoModalState> {
    state: IAreaInfoModalState = {
        areaId: '',
    };

    constructor(areInfoProps: IAreaInfoModalProps) {
        super(areInfoProps);
        const props: Dict<any> = this.props;
        const areaId = props && props.match && props.match.params && props.match.params.polyId
            && decodeURIComponent(props.match.params.polyId) || '';
        this.state = { areaId };
    }

    componentDidUpdate(prevProps: Readonly<IAreaInfoModalProps>, prevState: Readonly<IAreaInfoModalState>): void {
        const props: Dict<any> = this.props;
        const prevAreaProps: Dict<any> = prevProps;
        const areaId = props && props.match && props.match.params && props.match.params.polyId
            && decodeURIComponent(props.match.params.polyId) || '';
        const nextAreaId = prevAreaProps && prevAreaProps.match
            && prevAreaProps.match.params && prevAreaProps.match.params.polyId
            && decodeURIComponent(prevAreaProps.match.params.polyId) || '';

        if (areaId !== nextAreaId) {
            this.getData();
        }
    }

    shouldComponentUpdate(
        nextAreaProps: Readonly<IAreaInfoModalProps>,
        nextState: Readonly<IAreaInfoModalState>,
    ): boolean {
        const props: Dict<any> = this.props;
        const nextProps: Dict<any> = nextAreaProps;
        const areaId = props && props.match && props.match.params && props.match.params.polyId
            && decodeURIComponent(props.match.params.polyId) || '';
        const nextAreaId = nextProps && nextProps.match && nextProps.match.params && nextProps.match.params.polyId
            && decodeURIComponent(nextProps.match.params.polyId) || '';

        return areaId !== nextAreaId || this.state.areaId !== nextState.areaId;
    }

    getData() {
        const props: Dict<any> = this.props;
        const areaId = props && props.match && props.match.params && props.match.params.polyId
            && decodeURIComponent(props.match.params.polyId) || '';
        this.setState({ areaId });
    }

    onClose() {
        location.hash = `#/settings/poly`;
    }

    render() {
        const areaId = decodeURIComponent(this.state.areaId);

        return <Window title={'Информация по полигону'}
                       onClose={this.onClose.bind(this)}>
            <CurrentAreaTags areaId={areaId}/>
            <AreaTagsHistory areaId={areaId}/>
            <AreaHistory areaId={areaId}/>
        </Window>;
    }
}
