import React from 'react';

import { Button } from '../../../../ui/Button';
import { IPolygonItem } from '../component';
import { ModalWindow } from './ModalWindow';

interface IPackageDeleteTags {
    areas: IPolygonItem[];
    isLoading: boolean;
    updateAreas: () => void;
}

export const PackageDeleteTags = (props: IPackageDeleteTags) => {
    const { areas, isLoading, updateAreas } = props;
    const [isOpen, setIsOpen] = React.useState(false);

    return (
        <>
            <Button onClick={() => setIsOpen(true)}
                    disabled={isLoading || areas.length === 0}>
                Пакетное удаление тегов
            </Button>
            {
                isOpen
                    ? <ModalWindow isWorking={isLoading}
                                   onClose={() => setIsOpen(false)}
                                   areas={areas}
                                   updateAreas={updateAreas}/>
                    : null
            }
        </>
    );
};
