import * as React from 'react';

import { Window } from '../../../ui/FullModal';
import { AddPromo } from './AddPromo';

interface IAddPromoModalProps {
    onClose: () => void;
    fetchData: () => void;
}

interface IAddPromoModalState {
    error: Error | null;
}

export class AddPromoModal extends React.Component<IAddPromoModalProps, IAddPromoModalState> {
    state: IAddPromoModalState = {
        error: null,
    };

    setError(error) {
        this.setState({
            error,
        });
    }

    afterFetch() {
        this.props.onClose();
        this.props.fetchData();
    }

    render() {
        const { onClose } = this.props;
        const { error } = this.state;

        return (
            <Window onClose={onClose}
                    title={'Добавить серию'}
                    error={error}>
                <AddPromo setError={this.setError.bind(this)}
                          newGenerator={[]}
                          afterFetch={this.afterFetch.bind(this)}/>
            </Window>
        );
    }
}
