import moment from 'moment';
import * as React from 'react';

import { Button } from '../../../ui/Button';
import { Window } from '../../../ui/FullModal';
import { Input } from '../../../ui/Input';
import { Request2 } from '../../../utils/request';
import { download } from '../../../utils/utils';
import { IPromo } from '../../Clients/BonusView/BonusViewPromo';
import { REQUESTS, SETTINGS_REQUESTS } from '../request';
import * as modalStyles from '../Wallets/AddModal.css';
import * as styles from './index.css';

interface IGiveOutPromoModalProps {
    onClose: () => void;
    fetchData: () => void;
    data: IPromo[];
}

interface IGiveOutPromoModalState {
    error: Error | null;
    isButtonLoading: boolean;
    fileName: string;
    isGivenOut: boolean;
}

export class GiveOutPromoModal extends React.Component<IGiveOutPromoModalProps, IGiveOutPromoModalState> {
    state: IGiveOutPromoModalState = {
        error: null,
        isButtonLoading: false,
        fileName: '',
        isGivenOut: false,
    };

    request = new Request2({ requestConfigs: SETTINGS_REQUESTS });
    timestamp = `${moment().format('YYYYMMDD-HHmmss')}-`;

    onChange(fileName: string) {
        this.setState({
            fileName,
        });
    }

    sendData() {
        let { data, onClose, fetchData } = this.props;
        const { fileName } = this.state;

        if (!(data && Array.isArray(data))) {
            data = [];
        }

        const ids = data.map(code => code.id);

        this.setState({
            isButtonLoading: true,
        }, () => {
            const data = { ids, given_out_info: `${this.timestamp}${fileName}` };

            this.request.exec(REQUESTS.GIVE_OUT_PROMO, {
                body: {
                    ...data,
                },
            })
                .then((response) => {
                    const { codes = [] } = response || {};
                    const csv = codes && Array.isArray(codes) && codes.join('\n');
                    this.setState({
                        isButtonLoading: false,
                    });
                    download(csv, `${this.timestamp}${fileName}.csv`, 'text/csv');
                    onClose();
                    fetchData();
                })
                .catch((error) => {
                    this.setState({
                        isButtonLoading: false,
                        error,
                    });
                });
        });
    }

    componentDidMount(): void {
        let { data } = this.props;

        if (!(data && Array.isArray(data))) {
            data = [];
        }

        const isGivenOut = data.some(el => !!el.given_out);

        this.setState({
            isGivenOut,
        });
    }

    render() {
        const { onClose } = this.props;
        const { error, fileName, isButtonLoading, isGivenOut } = this.state;

        return (
            <Window className={styles.giveOutPromo}
                    onClose={onClose.bind(this)}
                    title={'Раздать промо и сохранить в файл'}
                    error={error}>
                {isGivenOut && (
                    <h4>Некоторые коды уже раздавались</h4>
                )}
                <div className={styles.giveOutPromoInput}>
                    <span>{this.timestamp}</span>
                    <Input value={fileName}
                           onChange={this.onChange.bind(this)}
                           placeholder={'Куда отдаем?'}/>
                </div>
                <div className={modalStyles.buttonContainer}>
                    <Button onClick={onClose}
                            basic>Отмена</Button>
                    <Button disabled={!fileName}
                            onClick={this.sendData.bind(this)}
                            isLoading={isButtonLoading}>Отдать</Button>
                </div>
            </Window>
        );
    }
}
