import moment from 'moment';

import { ONE_SECOND } from '../../../constants';
import { controlType } from '../../FormConstructor/types';

export const FALLBACK_PROMO_SCHEMA = {
    prefix: {
        type: controlType.string,
        display_name: 'prefix',
        order: 3,
    },
    count_symbols: {
        type: controlType.numeric,
        display_name: 'количество добавочных к префиксу символов',
        order: 4,
    },
    generator: {
        'order': 2,
        'type': controlType.variants,
        'multi_select': false,
        'display_name': 'generator',
    },
    count: {
        type: controlType.numeric,
        display_name: 'количество промо',
        order: 4,
    },
    upper_literals_usage: {
        type: controlType.bool,
        display_name: 'можно ли использовать Upper case буквы',
        default: true,
        order: 4,
    },
    lower_literals_usage: {
        type: controlType.bool,
        display_name: 'можно ли использовать lower case буквы',
        default: true,
        order: 4,
    },
    digits_usage: {
        type: controlType.bool,
        display_name: 'можно ли использовать цифры',
        default: true,
        order: 4,
    },
    given_out: {
        type: controlType.string,
        display_name: 'кому отдаем',
        order: 4,
    },
    activity_start: {
        type: controlType.numeric,
        display_name: 'activity_start',
        visual: 'timestamp',
        order: 4,
    },
    activity_deadline: {
        type: controlType.numeric,
        display_name: 'activity_deadline',
        visual: 'timestamp',
        order: 4,
    },
    removing_deadline: {
        type: controlType.numeric,
        display_name: 'removing_deadline (служебное)',
        visual: 'timestamp',
        order: 4,
        default: +(+moment(new Date()).add(1, 'year') / ONE_SECOND).toFixed(0),
    },
};
