import * as React from 'react';

import { Button } from '../../../../ui/Button';
import * as mainStyles from '../../../../ui/index.css';
import * as coreStyles from '../index.css';
import { PROMOCODE_WIZARD_ROUTE } from '../types';

interface IChoiceQuestionProps {
    changeStep: () => void;
    question: string;
    options: {name: string; stepConfig: PROMOCODE_WIZARD_ROUTE}[];
}

export const ChoiceQuestion = (props: IChoiceQuestionProps) => {
    const { question, options, changeStep } = props;

    return (
        <div className={coreStyles.pw_container}>
            <div className={coreStyles.pw_wrapper}>
                {question && <p>{question}</p>}
                <div className={mainStyles.button_container}>
                    {options.map((option, index) => {
                        return (
                            <Button key={`cq_${index}`}
                                    onClick={changeStep.bind(null, option.stepConfig)}
                                    basic>{option.name}</Button>
                        );
                    })}
                </div>
            </div>
        </div>
    );
};
